
:- dynamic p/1 as incremental.
:- dynamic q/1 as incremental.
:- import incr_assert/1, incr_retract/1 from increval.
%:- import lazy_reeval/1 from increval.
%:- ensure_loaded(xsbbrat).

test:- abolish_all_tables,test_clcl_1,fail.
test:- abolish_all_tables,test_clcl_2,fail.
test:- abolish_all_tables,test_lazy_1,fail.
test:- abolish_all_tables,test_lazy_2,fail.
test:- abolish_all_tables,test_dag,fail.
test:- abolish_all_tables,test_cycle,fail.
test:- abolish_all_tables,test_incompletes,fail.
test:- abolish_all_tables,test_visitors,fail.
test.

/* test propagation of a change */
test_clcl_1:- t_inc_5(X),writeln(clcl_1_one(X)),fail.
test_clcl_1:- incr_assert(p(3)),fail.
test_clcl_1:- t_inc_5(X),writeln(clcl_1_two(X)),fail.
test_clcl_1.

/* test non-propagation of a spurious change */
test_clcl_2:- t_inc_5(X),writeln(clcl_2_one(X)),fail.
test_clcl_2:- incr_retract(p(3)),fail.
test_clcl_2:- incr_assert(p(3)),fail.
test_clcl_2:- t_inc_5(X),writeln(clcl_2_two(X)),fail.
test_clcl_2.

/* test propagation of a change */
test_lazy_1:- t_inc_5(X),writeln(lazy_one_1(X)),fail.
test_lazy_1:- incr_retract(p(3)),fail.
test_lazy_1:- t_inc_5(X),writeln(lazy_two_1(X)),fail.
test_lazy_1.

/* test non-propagation of a spurious change */
test_lazy_2:- t_inc_5(X),writeln(lazy_one_2(X)),fail.
test_lazy_2:- incr_assert(p(3)),fail.
test_lazy_2:- incr_retract(p(3)),fail.
test_lazy_2:- t_inc_5(X),writeln(lazy_two_2(X)),fail.
test_lazy_2.

test_dag:- dag_1(X),writeln(dag_before(X)),fail.
test_dag:- incr_assert(p(3)),fail.
test_dag:- dag_1(X),writeln(dag_lazy(X)),fail.
test_dag.

test_cycle:- cycle(1,Y),writeln(cycle_before(1,Y)),fail.
test_cycle:- incr_assert(p(3,4)),fail.
test_cycle:- cycle(1,Y),writeln(cycle_lazy(1,Y)),fail.
test_cycle.

test_incompletes:- catch(cyc_incomp(1,_Y),_,writeln(cyc_incomp_caught)),fail.
test_incompletes.

test_visitors:- t_inc_5(X),writeln(one(X)),
		incr_retract(p(3)),
		t_inc_5(Y),writeln(two(Y)),fail.
test_visitors.
/* also need to test cycles; negation */

p(1). p(2).

q(1). q(2). q(3).

:- table t_inc_2/1,t_inc_3/1,t_inc_4/1,t_inc_5/1 as incremental.
:- table t_inc_1/1 as incremental.

t_inc_1(X):- p(X).
t_inc_2(X):- q(X).
t_inc_3(X):- t_inc_1(X).
t_inc_4(X):- t_inc_3(X).
%t_inc_5(X):- t_inc_4(X),writeln(t_inc_4(X)),t_inc_2(X),writeln(t_inc_2(X)).
t_inc_5(X):- writeln(resolving_t_inc_5),t_inc_4(X),t_inc_2(X).
t_inc_6(X):- t_inc_4(X),t_inc_2(_Y).

inc_7(X):- t_inc_1(X),t_inc_1(X).

test_deps(X):-
	    t_inc_5(X),
	    incr_retract_immed(p(2)).


:- table dag_1/1, dag_2/1, dag_3/1 as incremental.
dag_1(X):- dag_2(X),dag_3(Y), Y = X.
dag_2(X):- dag_3(X).
dag_3(X):- p(X).

:- table cycle/2 as incremental.
cycle(X,Y):- cycle(X,Z),p(Z,Y).
cycle(X,Y):- p(X,Y).

:- dynamic p/2 as incremental.
p(1,2).
p(2,3).

:- table cyc_incomp/2 as incremental.
cyc_incomp(X,Y):- cyc_incomp(X,Z),writeln(cyc(X,Z)),p(Z,Y).
cyc_incomp(X,Y):- p(X,Y),
	   Y1 is Y + 1,
	   incr_assert(p(X,Y1)).

end_of_file.


ok(X):- t_inc_1(X).

bad_2:- t_inc_4(_X),fail.
bad_2:- writeln(first_clause_done),inc_7(X),writeln(t_inc_5(X)),fail.

bad_3:- t_inc_4(_X),fail.
bad_3:- writeln(first_clause_done),t_inc_5(X),writeln(t_inc_5(X)),fail.

test_recompute:- t_inc_5(X),writeln(one(X)),fail.
test_recompute:- incr_assert(p(3)),fail.
test_recompute:- t_inc_5(X),writeln(two(X)),fail.

retractall_p:-
	writeln(here),
	p(X),incr_retract_immed(p(X)),fail.
retractall_p.

