% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dateModified.R
\name{dateModified}
\alias{dateModified}
\alias{dateModified,character-method}
\alias{dateModified,SsimLibrary-method}
\alias{dateModified,Project-method}
\alias{dateModified,Scenario-method}
\title{Last date a SsimLibrary, Project or Scenario was modified}
\usage{
dateModified(ssimObject)

\S4method{dateModified}{character}(ssimObject)

\S4method{dateModified}{SsimLibrary}(ssimObject)

\S4method{dateModified}{Project}(ssimObject)

\S4method{dateModified}{Scenario}(ssimObject)
}
\arguments{
\item{ssimObject}{\code{\link{SsimLibrary}}, \code{\link{Project}},
or \code{\link{Scenario}} object}
}
\value{
A character string: date and time of the most recent modification
to the SsimObject provided as input.
}
\description{
The most recent modification date of a \code{\link{SsimLibrary}},
\code{\link{Project}} or \code{\link{Scenario}}.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session and SsimLibrary
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Check the last date of modification of the SsimLibrary
dateModified(myLibrary)
}

}
