% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chartOptionsYAxis.R
\name{chartOptionsYAxis}
\alias{chartOptionsYAxis}
\alias{chartOptionsYAxis,Chart-method}
\title{Modify the Y axis of a \code{\link{Chart}}}
\usage{
chartOptionsYAxis(
  chart,
  title = NULL,
  numberStyle = NULL,
  decimals = NULL,
  thousandsSeparator = NULL,
  minZero = NULL,
  sameScale = NULL,
  fixedIntervals = NULL
)

\S4method{chartOptionsYAxis}{Chart}(
  chart,
  title = NULL,
  numberStyle = NULL,
  decimals = NULL,
  thousandsSeparator = NULL,
  minZero = NULL,
  sameScale = NULL,
  fixedIntervals = NULL
)
}
\arguments{
\item{chart}{\code{\link{Chart}} object}

\item{title}{character. Title of the Y axis. Default is \code{NULL}.}

\item{numberStyle}{character. Sets the style for the axes labels. Options
include "number", scientific", or "currency". Default is \code{NULL}.}

\item{decimals}{float. Sets the number of decimal places to be displayed in
the axes labels. Values can be between 0 and 8. Default is \code{NULL}.}

\item{thousandsSeparator}{logical. Whether to use a thousand separator
(i.e., 1,000,000). Default is \code{NULL}.}

\item{minZero}{logical. Whether the minimum value displayed in the Y axis
should be zero.}

\item{sameScale}{logical. Whether the Y axis scale should be consistent
across chart panels. Default is \code{NULL}.}

\item{fixedIntervals}{logical. Whether the interval between Y axis labels
should be consistent across chart panels. Default is \code{NULL}.}
}
\value{
A \code{Chart} object representing a SyncroSim chart or, if no arguments
other than the chart are provided, a data.frame of the current chart Y axis
settings.
}
\description{
Set the title and style of the Y axis of a \code{\link{Chart}}.
}
\examples{
\dontrun{
# Open a chart object
myChart <- chart(myProject, chart = "My Chart")

# Set the chart Y axis title
myChart <- chartOptionsYAxis(myChart, title = "Year")

# Return a dataframe of the current Y axis settings
myChart <- chartOptionsYAxis(myChart)
}

}
