% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteLibrary.R
\name{deleteLibrary}
\alias{deleteLibrary}
\alias{deleteLibrary,SsimLibrary-method}
\alias{deleteLibrary,character-method}
\title{Delete Library}
\usage{
deleteLibrary(
  ssimLibrary,
  force = FALSE,
  removeBackup = FALSE,
  removePublish = FALSE,
  removeCustom = FALSE,
  session = NULL
)

\S4method{deleteLibrary}{SsimLibrary}(ssimLibrary, force, removeBackup, removePublish, removeCustom)

\S4method{deleteLibrary}{character}(
  ssimLibrary,
  force = FALSE,
  removeBackup = FALSE,
  removePublish = FALSE,
  removeCustom = FALSE,
  session = NULL
)
}
\arguments{
\item{ssimLibrary}{SsimLibrary or path to a library}

\item{force}{Logical. If FALSE (default) prompt to confirm that the library
should be deleted. This is irreversable.}

\item{removeBackup}{logical. If \code{TRUE}, will remove the backup folder when
deleting a library. Default is FALSE.}

\item{removePublish}{logical. If TRUE, will remove the publish folder when
deleting a library. Default is FALSE.}

\item{removeCustom}{logical. If TRUE and custom folders have been configured
for a library, then will remove the custom publish and/or backup folders when
deleting a library. Note that the \code{removePublish} and \code{removeBackup} arguments
must also be set to TRUE to remove the respective custom folders. Default
is FALSE.}

\item{session}{Session}
}
\value{
"saved" or failure message.
}
\description{
Deletes a SyncroSim library. Note this is irreversable.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session and create SsimLibrary
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
 
# Delete library from SsimObject
deleteLibrary(myLibrary, force = TRUE, removeBackup = TRUE)

# Create another library
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)

# Delete library from path
deleteLibrary(myLibraryName)
}

}
