% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_funs.R
\name{add_overall_level}
\alias{add_overall_level}
\title{Add an virtual 'overall' level to split}
\usage{
add_overall_level(
  valname = "Overall",
  label = valname,
  extra_args = list(),
  first = TRUE,
  trim = FALSE
)
}
\arguments{
\item{valname}{character(1). 'Value' to be assigned to the implicit
all-observations split level. Defaults to \code{"Overall"}}

\item{label}{character(1). A label (not to be confused with the name) for the
object/structure.}

\item{extra_args}{list. Extra arguments to be passed to the tabulation
function. Element position in the list corresponds to the children of this
split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{first}{logical(1). Should the implicit level appear first (\code{TRUE})
or last \code{FALSE}. Defaults to \code{TRUE}.}

\item{trim}{logical(1). Should splits corresponding with 0 observations be
kept when tabulating.}
}
\value{
a closure suitable for use as a splitting function (\code{splfun})
when creating a table layout
}
\description{
Add an virtual 'overall' level to split
}
\examples{

lyt <- basic_table() \%>\%
  split_cols_by("ARM", split_fun = add_overall_level("All Patients",
    first = FALSE
  )) \%>\%
  analyze("AGE")

tbl <- build_table(lyt, DM)
tbl

lyt2 <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  split_rows_by("RACE",
    split_fun = add_overall_level("All Ethnicities")
  ) \%>\%
  summarize_row_groups(label_fstr = "\%s (n)") \%>\%
  analyze("AGE")
lyt2

tbl2 <- build_table(lyt2, DM)
tbl2

}
