% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\docType{class}
\name{VarLevelSplit-class}
\alias{VarLevelSplit-class}
\alias{VarLevelSplit}
\alias{VarLevWBaselineSplit}
\title{Split on levels within a variable}
\usage{
VarLevelSplit(
  var,
  split_label,
  labels_var = NULL,
  cfun = NULL,
  cformat = NULL,
  cna_str = NA_character_,
  split_fun = NULL,
  split_format = NULL,
  split_na_str = NA_character_,
  valorder = NULL,
  split_name = var,
  child_labels = c("default", "visible", "hidden"),
  extra_args = list(),
  indent_mod = 0L,
  label_pos = c("topleft", "hidden", "visible"),
  cindent_mod = 0L,
  cvar = "",
  cextra_args = list(),
  page_prefix = NA_character_,
  section_div = NA_character_,
  show_colcounts = FALSE,
  colcount_format = NULL
)

VarLevWBaselineSplit(
  var,
  ref_group,
  labels_var = var,
  split_label,
  split_fun = NULL,
  label_fstr = "\%s - \%s",
  cfun = NULL,
  cformat = NULL,
  cna_str = NA_character_,
  cvar = "",
  split_format = NULL,
  split_na_str = NA_character_,
  valorder = NULL,
  split_name = var,
  extra_args = list(),
  show_colcounts = FALSE,
  colcount_format = NULL
)
}
\arguments{
\item{var}{(\code{string})\cr variable name.}

\item{split_label}{(\code{string})\cr label to be associated with the table generated by the split. Not to be confused
with labels assigned to each child (which are based on the data and type of split during tabulation).}

\item{labels_var}{(\code{string})\cr name of variable containing labels to be displayed for the values of \code{var}.}

\item{cfun}{(\code{list}, \code{function}, or \code{NULL})\cr tabulation function(s) for creating content rows. Must accept \code{x}
or \code{df} as first parameter. Must accept \code{labelstr} as the second argument. Can optionally accept all optional
arguments accepted by analysis functions. See \code{\link[=analyze]{analyze()}}.}

\item{cformat}{(\code{string}, \code{function}, or \code{list})\cr format for content rows.}

\item{cna_str}{(\code{character})\cr NA string for use with \code{cformat} for content table.}

\item{split_fun}{(\code{function} or \code{NULL})\cr custom splitting function. See \link{custom_split_funs}.}

\item{split_format}{(\code{string}, \code{function}, or \code{list})\cr default format associated with the split being created.}

\item{split_na_str}{(\code{character})\cr NA string vector for use with \code{split_format}.}

\item{valorder}{(\code{character})\cr the order that the split children should appear in resulting table.}

\item{split_name}{(\code{string})\cr name associated with the split (for pathing, etc.).}

\item{child_labels}{(\code{string})\cr the display behavior for the labels (i.e. label rows) of the children of this
split. Accepts \code{"default"}, \code{"visible"}, and \code{"hidden"}. Defaults to \code{"default"} which flags the label row as
visible only if the child has 0 content rows.}

\item{extra_args}{(\code{list})\cr extra arguments to be passed to the tabulation function. Element position in the list
corresponds to the children of this split. Named elements in the child-specific lists are ignored if they do
not match a formal argument of the tabulation function.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{label_pos}{(\code{string})\cr location where the variable label should be displayed. Accepts \code{"hidden"}
(default for non-analyze row splits), \code{"visible"}, \code{"topleft"}, and \code{"default"} (for analyze splits only). For
\code{analyze} calls, \code{"default"} indicates that the variable should be visible if and only if multiple variables are
analyzed at the same level of nesting.}

\item{cindent_mod}{(\code{numeric(1)})\cr the indent modifier for the content tables generated by this split.}

\item{cvar}{(\code{string})\cr the variable, if any, that the content function should accept. Defaults to \code{NA}.}

\item{cextra_args}{(\code{list})\cr extra arguments to be passed to the content function when tabulating row group
summaries.}

\item{page_prefix}{(\code{string})\cr prefix to be appended with the split value when forcing pagination between
the children of a split/table.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group defined
by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{show_colcounts}{(\code{logical(1)})\cr should column counts be displayed at the level
facets created by this split. Defaults to \code{FALSE}.}

\item{colcount_format}{(\code{character(1)})\cr if \code{show_colcounts} is \code{TRUE}, the
format which should be used to display column counts for facets generated by
this split. Defaults to \code{"(N=xx)"}.}

\item{ref_group}{(\code{character})\cr value of \code{var} to be taken as the \code{ref_group}/control to be compared against.}

\item{label_fstr}{(\code{string})\cr a \code{sprintf} style format string. For non-comparison splits, it can contain up to
one \code{"\\\%s"} which takes the current split value and generates the row/column label. For comparison-based splits
it can contain up to two \code{"\\\%s"}.}
}
\value{
a \code{VarLevelSplit} object.
}
\description{
Split on levels within a variable
}
\author{
Gabriel Becker
}
