% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colby_constructors.R
\name{add_colcounts}
\alias{add_colcounts}
\title{Add the column population counts to the header}
\usage{
add_colcounts(lyt, format = "(N=xx)")
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout object pre-data used for tabulation.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}
}
\value{
A \code{PreDataTableLayouts} object suitable for passing to further layouting functions, and to \code{\link[=build_table]{build_table()}}.
}
\description{
Add the data derived column counts.
}
\details{
It is often the case that the the column counts derived from the
input data to \code{\link[=build_table]{build_table()}} is not representative of the population counts.
For example, if events are counted in the table and the header should
display the number of subjects and not the total number of events.
}
\examples{
lyt <- basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  add_colcounts() \%>\%
  split_rows_by("RACE", split_fun = drop_split_levels) \%>\%
  analyze("AGE", afun = function(x) list(min = min(x), max = max(x)))
lyt

tbl <- build_table(lyt, DM)
tbl

}
\author{
Gabriel Becker
}
