% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_aaa_data}
\alias{read_aaa_data}
\title{Data import function.}
\usage{
read_aaa_data(
  file,
  coordinates = "cartesian",
  format = "long",
  na_rm = TRUE,
  knots = NULL,
  column_names = NULL
)
}
\arguments{
\item{file}{The file or files with AAA data.}

\item{coordinates}{A string specifying the coordinate system. Possible values are \code{"cartesian"} and \code{"polar"}.}

\item{format}{A string specifying the data format. Possible values are \code{"long"} and \code{"wide"} (the default is \code{"long"}).}

\item{na_rm}{Remove NAs.}

\item{knots}{The number of spline knots.}

\item{column_names}{The names of the columns without including the splines columns.}
}
\value{
An object of class \code{\link[tibble]{tbl_df-class}} (a tibble).
}
\description{
It reads a file with data exported from AAA. The data are automatically
transformed from a wide to a long format (each row has values of X or Y axes
for each fan line). The imported tibble can then be used for plotting and
statistical analysis.
}
\keyword{internal}
