% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_membersponsorcompare.R
\name{cg_membersponsorcompare}
\alias{cg_membersponsorcompare}
\title{Compare bill sponsorship between two members who served in the same Congress
and chamber.}
\usage{
cg_membersponsorcompare(memberid_1 = NULL, memberid_2 = NULL,
  congress_no = NULL, chamber = NULL, key = NULL, ...)
}
\arguments{
\item{memberid_1}{The member's unique ID number (alphanumeric). To find a
member's ID number, get the list of members for the appropriate House
or Senate. You can also use the Biographical Directory of the United
States Congress to get a member's ID. In search results, each member's
name is linked to a record by index ID (e.g.,
http://bioguide.congress.gov/scripts/biodisplay.pl?index=C001041).
Use the index ID as member-id in your request.}

\item{memberid_2}{See description for memberid_1.}

\item{congress_no}{The number of the Congress during which the members served.}

\item{chamber}{One of 'house' or 'senate.}

\item{key}{(character) your Propublica API key; pass in, or loads from .Renviron
as \code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to \code{\link[httr]{GET}}}
}
\value{
Compare bill sponsorship between two members who served in the same
   Congress and chamber.
}
\description{
Compare bill sponsorship between two members who served in the same Congress
and chamber.
}
\examples{
\dontrun{
cg_membersponsorcompare(memberid_1 = 'S001181', memberid_2 = 'A000368', 
 congress_no = 112, chamber = 'senate')
}
}
