% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cg_rollcallvote.R
\name{cg_rollcallvote}
\alias{cg_rollcallvote}
\title{Get a specific roll-call vote, including a complete list of member positions.}
\usage{
cg_rollcallvote(congress_no = NULL, chamber = NULL, session_no = NULL,
  rollcall_no = NULL, key = NULL, ...)
}
\arguments{
\item{congress_no}{The number of the Congress during which the members served.}

\item{chamber}{One of 'house' or 'senate.}

\item{session_no}{1, 2, or special session number (For a detailed list of
Congressional sessions, see
http://www.senate.gov/reference/resources/pdf/congresses2.pdf).}

\item{rollcall_no}{Integer. To get roll-call numbers, see the official sites
of the US Senate
(http://www.senate.gov/pagelayout/legislative/a_three_sections_with_teasers/votes.htm),
and US House (http://artandhistory.house.gov/house_history/index.aspx).}

\item{key}{(character) your Propublica API key; pass in, or loads from .Renviron
as \code{PROPUBLICA_API_KEY}. See \code{\link{rtimes-package}} for info on rate limits.}

\item{...}{Curl options (debugging tools mostly) passed to \code{\link[httr]{GET}}}
}
\value{
Get a specific roll-call vote, including a complete list of member
   positions. A list with metadata about the bill, and vote results.
}
\description{
Get a specific roll-call vote, including a complete list of member positions.
}
\examples{
\dontrun{
cg_rollcallvote(congress_no = 105, chamber = 'house', session_no = 2, 
  rollcall_no = 38)
}
}
