% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo_search.R
\name{geo_search}
\alias{geo_search}
\title{Geographic search NYTimes API}
\usage{
geo_search(name = NULL, latitude = NULL, longitude = NULL,
  elevation = NULL, population = NULL, country_code = NULL,
  country_name = NULL, admin_code1 = NULL, admin_name1 = NULL,
  admin_code2 = NULL, admin_name2 = NULL, admin_code3 = NULL,
  admin_name3 = NULL, admin_code4 = NULL, admin_name4 = NULL,
  feature_class = NULL, feature_class_name = NULL,
  feature_code_name = NULL, time_zone_id = NULL, dst_offset = NULL,
  gmt_offset = NULL, bounding_box = NULL, nearby = NULL, offset = NULL,
  limit = 100, key = NULL, ...)
}
\arguments{
\item{name}{(character) A displayable name for the specified place.}

\item{latitude}{(numeric) The latitude of the specified place.}

\item{longitude}{(numeric) The longitude of the specified place.}

\item{elevation}{(character) The elevation of the specified place, in meters.}

\item{population}{(numeric) Te population of the specified place.}

\item{country_code}{(character) The country code, as given in ISO-3611, of the specified place.}

\item{country_name}{(character) The country name of the specified place.}

\item{admin_code1}{(character) A code for the first level administrative division containing
the specified place. In the case of US locations this will be the containing state's postal
code. All geonames admin_code1 records can be found at
http://download.geonames.org/export/dump/admin1Codes.txt.}

\item{admin_name1}{(character) The name of the first level administrative division containing
the specified place. In the case of US locations this will be the full name of the containing
State.}

\item{admin_code2}{(character) A code for the second level administrative division containing
the specified place. In the case of US locations this will be a code for the containing county.
All geonames admin_code2 records can be found at
http://download.geonames.org/export/dump/admin2Codes.txt}

\item{admin_name2}{(character) The name of the second level administrative division containing
the specified place. In the case of US locations this will be the name of the containing county.}

\item{admin_code3}{(character) A code for the third level administrative division containing the
specified place. This is infrequently used and never used for US locations.}

\item{admin_name3}{(character) The name of the third level administrative division containing
the specified place. This is infrequently used and never used for US locations.}

\item{admin_code4}{(character) A code for the fourth level administrative division containing
the specified place. This is infrequently used and never used for US locations.}

\item{admin_name4}{(character) The name of the fourth level administrative division containing
the specified place. This is infrequently used and never used for US locations.}

\item{feature_class}{(character) The high-level feature class of the location. The feature
classes are as follows:
\itemize{
 \item A - Administrative Boundary Features
 \item H - Hydrographic Features
 \item L - Area Features
 \item P - Populated Place Features
 \item R - Road / Railroad Features
 \item S - Spot Features
 \item T - Hypsographic Features
 \item U - Undersea Features
 \item V - Vegetation Features
}}

\item{feature_class_name}{(character) See list of name values associated with feature_class
above.}

\item{feature_code_name}{(character) A code for the type of feature represented by this geonames
record. The complete list of feature codes can be found at
http://download.geonames.org/export/dump/featureCodes_en.txt.}

\item{time_zone_id}{(character) The time zone containing this geonames record.}

\item{dst_offset}{(numeric) The offset from GMT during daylight savings time.}

\item{gmt_offset}{(numeric) The offset from GMT during standard time.}

\item{bounding_box}{(numeric) Vector of coordinates in the following format <NE Latitude>,
<NE Longitude>,<SW Latitude>,<SW Longitude>. For example:
c(39.985417852135356,-93.18850617968747,37.84003257271992,-95.94607453906247)}

\item{nearby}{(numeric) A latitude longitude pair (e.g. 41.9,12.5). When provided with this
parameter, the geocodes API will return the 20 results that are geographically nearest to the
specified latitude/longitude pair.}

\item{offset}{(numeric) The offset in the results. BEWARE - this parameter doesn't work now
(as of 2014-10-21).}

\item{limit}{(numeric) If not specified 20 results are returned. Otherwise the specified number
of results or a maximum of 20 results are returned. BEWARE - this parameter doesn't work now
(as of 2015-08-10).}

\item{key}{your New York Times API key; pass in, or loads from .Rprofile as
\code{nytimes_geo_key}, or from .Renviron as \code{NYTIMES_GEO_KEY}}

\item{...}{Curl options (debugging tools mostly) passed to
\link[crul:HttpClient]{crul::HttpClient}}
}
\description{
Geographic search NYTimes API
}
\details{
BEWARE: the docs are a hot mess - the README page has examples that
include parameters that are not in their list of accepted query
parameters. Some query parameter that used to work don't work now. There
seems to be no way to get a response from them. So good luck.
}
\examples{
\dontrun{
geo_search(country_code = 'US')
geo_search(feature_class='P', country_code='US', population='50000_')

# FIXME: these should work, but don't anymore
#geo_search(elevation = '2000_', feature_class='P')
#geo_search(elevation = '_3000', feature_class='P')
#geo_search(elevation = '2000_3000', feature_class='P')
# geo_search(nearby=c(38.920833,-94.622222), population='100000_', 
#   feature_class='P')

# curl options
geo_search(country_code = 'US', verbose = TRUE)
}
}
\references{
\url{http://developer.nytimes.com/geo_api_v2.json}
}
