% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc}
\alias{lc}
\title{Lorenz and Generalized Lorenz curves}
\usage{
lc(dataset, samp = 10, generalized = FALSE, plot = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing variables obtained by using the setupDataset function.}

\item{samp}{an integer which represents the number of ordinates to be estimated. The default is 10.}

\item{generalized}{logical; if TRUE the Generalized Lorenz curve ordinates will be estimated.}

\item{plot}{logical; if TRUE plots the Lorenz or Generalized Lorenz curve.}
}
\value{
A data.frame with the following components:
\itemize{
\item x.lg, vector of cumulated proportion of population.
\item y.lg, vector with values of the Lorenz or the Generalized Lorenz curves ordinates.
}
}
\description{
Estimates the Lorenz and the Generalized Lorenz curves ordinates.
}
\details{
Lorenz and Generalized Lorenz curves ordinates are computed using the equivalized disposable income. The equivalence scales employed are the modified OECD scale and the parametric scale of Buhmann et al. (1988) (see setupDataset).
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT", s = "OECD")
lc.curve <- lc(ATdataset)
str(lc.curve)

}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
\references{
B C Arnold (1987) Majorization and the Lorenz order: A brief introduction, Lecture Notes in Statistics, 43, Springer-Verlag.

B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.
}
\seealso{
setupDataset
}

