% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsr.R
\name{qsr}
\alias{qsr}
\title{Income quintile share ratio}
\usage{
qsr(dataset, ipuc = "ipuc", hhcsw = "DB090", hhsize = "HX040",
  ci = NULL, rep = 1000, verbose = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing the variables.}

\item{ipuc}{a character string indicating the variable name of the income per unit of consumption. Default is "ipuc".}

\item{hhcsw}{a character string indicating the variable name of the household cross-sectional weight. Default is "DB090".}

\item{hhsize}{a character string indicating the variable name of the household size. Default is "HX040".}

\item{ci}{a scalar or vector containing the confidence level(s) of the required interval(s). Default does not calculate the confidence interval.}

\item{rep}{a number to do the confidence interval using boostrap technique.}

\item{verbose}{logical; if TRUE the confidence interval is plotted.}
}
\value{
The value of the income quintile share ratio.
}
\description{
Estimates the  quintile share ratio of an income distribution. It is defined as the ratio of total income  received by the 20 percent of the population with the highest income to that received by the 20 percent of the population with the lowest income.
}
\details{
It is calculated using the equivalised disposable income. Two types of equivalence scales can be used, the modified OECD scale and the parametric scale of Buhmann et al. ( 1988). The default is the modified OECD scale  (see setupDataset).
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT")
qsr(ATdataset)

}
\references{
B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.

\url{http://ec.europa.eu/eurostat/statistics-explained/index.php/Glossary:Income_quintile_share_ratio}
}
\seealso{
setupDataset
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
