% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{ClusterStrategy}
\alias{ClusterStrategy}
\alias{ClusterStrategy-class}
\title{Constructor of [\code{\linkS4class{ClusterStrategy}}] class}
\description{
This class encapsulate the parameters of the strategy of estimation of the rtkpp
Cluster models.
}
\section{Slots}{

\describe{
\item{\code{nbTry}}{Integer defining the number of tries. Default value: 1.}

\item{\code{nbShortRun}}{Integer defining the number of short run
(the strategy launch an initialization before each short run).}

\item{\code{initMethod}}{A [\code{\linkS4class{ClusterInit}}] object defining the way to
initialize the estimation method.}

\item{\code{shortAlgo}}{A [\code{\linkS4class{ClusterAlgo}}] object defining the algorithm
to use during the short runs of the estimation method.}

\item{\code{longAlgo}}{A [\code{\linkS4class{ClusterAlgo}}] object defining the algorithm
  to use during the long run of the estimation method.}
}}
\examples{
new("ClusterStrategy")
  shortAlgo=clusterAlgo("SEM",1000)
  longAlgo =clusterAlgo("SemiSEM",200,1e-07)
  new("ClusterStrategy", shortAlgo=shortAlgo, longAlgo=longAlgo)
  getSlots("ClusterStrategy")
}
\author{
Serge Iovleff
}

