% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{get_account_relationships}
\alias{get_account_relationships}
\title{Find out whether a given account is followed, blocked, muted, etc.}
\usage{
get_account_relationships(ids, token = NULL, parse = TRUE)
}
\arguments{
\item{ids}{vector of account ids}

\item{token}{user bearer token (read from file by default)}

\item{parse}{logical, if \code{TRUE}, the default, returns a tibble. Use \code{FALSE}  to return the "raw" list corresponding to the JSON returned from the Mastodon API.}
}
\value{
tibble or list of relationships
}
\description{
Find out whether a given account is followed, blocked, muted, etc.
}
\details{
this functions needs a user level auth token
}
\examples{
\dontrun{
fol <- get_account_followers("109302436954721982")
get_account_relationships(fol$id)
}
}
