% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrANCOVA.r
\name{qpcrANCOVA}
\alias{qpcrANCOVA}
\title{Fold change (FC) analysis using ANCOVA}
\usage{
qpcrANCOVA(
  x,
  numberOfrefGenes,
  analysisType = "ancova",
  mainFactor.column,
  mainFactor.level.order,
  block = NULL,
  width = 0.5,
  fill = "#BFEFFF",
  y.axis.adjust = 1,
  y.axis.by = 1,
  letter.position.adjust = 0.1,
  ylab = "Fold Change",
  xlab = "none",
  fontsize = 12,
  fontsizePvalue = 7,
  axis.text.x.angle = 0,
  axis.text.x.hjust = 0.5,
  x.axis.labels.rename = "none",
  p.adj = "none"
)
}
\arguments{
\item{x}{a data frame of condition (or conditions) levels, E (efficiency), genes and Ct values. Each Ct value in the data frame is the mean of technical replicates. Please refer to the vignette for preparing your data frame correctly.}

\item{numberOfrefGenes}{number of reference genes. Up to two reference genes can be handled.}

\item{analysisType}{should be one of "ancova" or "anova".}

\item{mainFactor.column}{main factor for which the levels FC is compared. The remaining factors are considered as covariates.}

\item{mainFactor.level.order}{a vector of main factor level names. The first level in the vector is used as reference.}

\item{block}{column name of the block if there is a blocking factor (for correct column arrangement see example data.). When a qPCR experiment is done in multiple qPCR plates, variation resulting from the plates may interfere with the actual amount of gene expression. One solution is to conduct each plate as a complete randomized block so that at least one replicate of each treatment and control is present on a plate. Block effect is usually considered as random and its interaction with any main effect is not considered.}

\item{width}{a positive number determining bar width.}

\item{fill}{specify the fill color for the columns in the bar plot. If a vector of two colors is specified, the reference level is differentialy colored.}

\item{y.axis.adjust}{a negative or positive value for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length}

\item{letter.position.adjust}{adjust the distance between the signs and the error bars.}

\item{ylab}{the title of the y axis}

\item{xlab}{the title of the x axis}

\item{fontsize}{font size of the plot}

\item{fontsizePvalue}{font size of the pvalue labels}

\item{axis.text.x.angle}{angle of x axis text}

\item{axis.text.x.hjust}{horizontal justification of x axis text}

\item{x.axis.labels.rename}{a vector replacing the x axis labels in the bar plot}

\item{p.adj}{Method for adjusting p values}
}
\value{
A list with 2 elements:
\describe{
  \item{Final_data}{}
  \item{lm_ANOVA}{lm of factorial analysis-tyle}
  \item{lm_ANCOVA}{lm of ANCOVA analysis-type}
  \item{ANOVA_table}{ANOVA table}
  \item{ANCOVA_table}{ANCOVA table}
  \item{FC Table}{Table of FC values, significance and confidence limits for the main factor levels.}
  \item{Bar plot of FC values}{Bar plot of the fold change values for the main factor levels.}
}
}
\description{
ANCOVA (analysis of covariance) and ANOVA (analysis of variance) can be performed using 
\code{qpcrANCOVA} function, for uni- or multi-factorial experiment data. This function performs FC analysis even
if there is only one factor (without covariate variable), although, for the data with 
only one factor, the analysis turns into ANOVA. The bar plot of the fold changes (FC) 
values along with the confidence interval is also returned by the \code{qpcrANCOVA} function.
}
\details{
The \code{qpcrANCOVA} function applies both ANCOVA and ANOVA analysis to the data of a uni- or 
multi-factorial experiment, although for the data with 
only one factor, the analysis turns to ANOVA. ANCOVA is basically appropriate when the 
levels of a factor are 
also affected by uncontrolled quantitative covariate(s). 
For example, suppose that wDCt of a target gene in a plant is affected by temperature. The gene may 
also be affected by drought. Since we already know that temperature affects the target gene, we are 
interested to know if the gene expression is also altered by the drought levels. We can design an 
experiment to understand the gene behavior at both temperature and drought levels at the same time. 
The drought is another factor (the covariate) that may affect the expression of our gene under the 
levels of the first factor i.e. temperature. The data of such an experiment can be analyzed by ANCOVA 
or even ANOVA based on a factorial experiment using \code{qpcrANCOVA}. This function performs FC 
analysis even there is only one factor (without covariate or factor  variable). Bar plot of fold changes 
(FC) values along with the pair-wise errors (square roots of pooled variances of each pair of samples) are also returned by the 
\code{qpcrANCOVA} function. There is also a function called \code{oneFACTORplot} which returns RE values 
and related plot for a one-factor-experiment with more than two levels.
Along with the ANCOVA, the \code{qpcrANCOVA} also performs a full model factorial analysis of variance. 
If there is covariate variable(s), before ANCOVA analysis, it is better to run ANOVA based on a 
factorial design to see if the main factor and covariate(s) interaction is significant or not. 
If the pvalue of the interaction effect is smaller than 0.05, then the interaction between the main factor and covariate 
is significant, suggesting that ANCOVA is not appropriate in this case.
}
\examples{

# Data from Lee et al., 2020 

df <- meanTech(Lee_etal2020qPCR, groups = 1:3)
order <- rev(unique(df$DS))
qpcrANCOVA(df, 
           numberOfrefGenes = 1, 
           analysisType = "ancova", 
           mainFactor.column = 2,
           mainFactor.level.order = order,
           fill = c("skyblue", "#BFEFFF"),
           y.axis.adjust = 0.05)


df <- meanTech(Lee_etal2020qPCR, groups = 1:3) 
df2 <- df[df$factor1 == "DSWHi",][-1]
qpcrANCOVA(df2, 
          mainFactor.column = 1,
          mainFactor.level.order = c("D7", "D12", "D15","D18"),
          numberOfrefGenes = 1,
          analysisType = "ancova",
          fontsizePvalue = 5,
          y.axis.adjust = 0.1)



addline_format <- function(x,...){gsub('\\\\s','\n',x)}
order <- unique(data_2factor$Drought)
qpcrANCOVA(data_1factor,
   numberOfrefGenes = 1,
   mainFactor.column = 1,
   mainFactor.level.order = c("L1","L2","L3"),
   width = 0.5,
   fill = c("skyblue","#79CDCD"),
   y.axis.by = 1,
   letter.position.adjust = 0,
   y.axis.adjust = 1,
   ylab = "Fold Change",
   fontsize = 12,
   x.axis.labels.rename = addline_format(c("Control", 
                                         "Treatment_1 vs Control", 
                                         "Treatment_2 vs Control")))
                                                       
                                                       
}
\references{
Livak, Kenneth J, and Thomas D Schmittgen. 2001. Analysis of
Relative Gene Expression Data Using Real-Time Quantitative PCR and the
Double Delta CT Method. Methods 25 (4). doi:10.1006/meth.2001.1262.

Ganger, MT, Dietz GD, and Ewing SJ. 2017. A common base method for analysis of qPCR data
and the application of simple blocking in qPCR experiments. BMC bioinformatics 18, 1-11.

Yuan, Joshua S, Ann Reed, Feng Chen, and Neal Stewart. 2006.
Statistical Analysis of Real-Time PCR Data. BMC Bioinformatics 7 (85). doi:10.1186/1471-2105-7-85.
}
\author{
Ghader Mirzaghaderi
}
