% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclude.R
\name{rtry_exclude}
\alias{rtry_exclude}
\title{Exclude (remove) data}
\usage{
rtry_exclude(input, ..., baseOn, showOverview = TRUE)
}
\arguments{
\item{input}{Input data frame or data table.}

\item{\dots}{Criteria for excluding.}

\item{baseOn}{The attribute on which excluding is based on. If it is set to \code{ObservationID},
the function excludes all records with the respective \code{ObservationID} if the
specified criteria for excluding is fulfilled for one record. Alternatively, use
\code{ObsDataID} to exclude only the record (row) for which the specified criterion
is fulfilled. Other reasonable parameter values are \code{TraitID}, \code{DataID}
or \code{AccSpeciesID}.}

\item{showOverview}{Default \code{TRUE} displays the dimension of the data after excluding.}
}
\value{
An object of the same type as the input data after excluding.
}
\description{
This function takes the input data frame or data table and excludes all records (rows)
with the same value in the attribute specified in the argument \code{baseOn} if the criteria
specified in the arguments for excluding (\code{\dots}) are fulfilled for one of those records.
}
\examples{
# Example 1: Exclude observations on juvenile plants or unknown state:
# Identify observations where the plant developmental status (DataID 413) is either
# "juvenile" or "unknown", and exclude the whole observation
data_filtered <- rtry_exclude(data_TRY_15160,
                   (DataID \%in\% 413) & (OrigValueStr \%in\% c("juvenile", "unknown")),
                   baseOn = ObservationID)

# Expected message:
# dim:   1618 28

# Example 2: Exclude outliers:
# Identify the outliers, i.e. trait records where the ErrorRisk is larger than 4
# and exclude these records (not the whole observation)
data_filtered <- rtry_exclude(data_TRY_15160,
                   ErrorRisk > 4,
                   baseOn = ObsDataID)

# Expected message:
# dim:   1778 28

# Learn more applications of the excluding function via the vignette (Workflow for
# general data preprocessing using rtry): vignette("rtry-workflow-general").
}
\references{
This function makes use of the \code{\link[base]{subset}} function
within the \code{base} package.
}
