% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{register.data.source}
\alias{register.data.source}
\alias{data.sources}
\title{Data Sources}
\usage{
register.data.source(src = "yahoo", data = ds.getSymbol.yahoo,
  storage = ds.storage.file.rdata(),
  functionality = ds.functionality.default(), overwrite = TRUE)

data.sources()
}
\arguments{
\item{src}{data source name, \strong{defaults to 'yahoo'}}

\item{data}{data source to download historical data, function must take Symbol, from, to parameters, \strong{defaults to ds.getSymbol.yahoo}}

\item{storage}{storage model configuration, \strong{defaults to ds.storage.file.rdata(src)}}

\item{functionality}{functionality configuration, \strong{defaults to ds.functionality.default()}}

\item{overwrite}{flag to overwrite data source if already registered in the list of plugins, \strong{defaults to True}}
}
\value{
None
}
\description{
List available data sources and Register new ones
}
\examples{
 # register data source to generate fake stock data for use in rtsdata examples
 register.data.source(src = 'sample', data = ds.getSymbol.fake.stock.data)

 # print allregistered data sources
 names(data.sources())

}
