% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/favorites.R
\name{get_favorites}
\alias{get_favorites}
\title{Get tweets data for statuses favorited by one or more target users.}
\usage{
get_favorites(
  user,
  n = 200,
  since_id = NULL,
  max_id = NULL,
  parse = TRUE,
  token = NULL
)
}
\arguments{
\item{user}{Vector of user names, user IDs, or a mixture of both.}

\item{n}{Specifies the number of records to retrieve. Defaults to
200. 3000 is the max number of favorites returned per token. Due
to suspended or deleted content, this function may return fewer
tweets than the desired (n) number. Must be of length 1 or of
length equal to the provided number of users.}

\item{since_id}{Returns results with an status_id greater than
(that is, more recent than) the specified status_id.  There are
limits to the number of tweets returned by the REST API. If the
limit is hit, since_id is adjusted (by Twitter) to the oldest ID
available.}

\item{max_id}{Character, returns results with an ID less than (that is,
older than) or equal to `max_id`.}

\item{parse}{Logical, indicating whether to return parsed vector or
nested list object. By default, \code{parse = TRUE}
saves you the time [and frustrations] associated with
disentangling the Twitter API return objects.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}
}
\value{
A tbl data frame of tweets data with users data attribute.
}
\description{
Returns up to 3,000 statuses favorited by each of one or more
specific Twitter users.
}
\examples{

\dontrun{

## get max number of statuses favorited by KFC
kfc <- get_favorites("KFC", n = 3000)
kfc

## get 400 statuses favorited by each of three users
favs <- get_favorites(c("Lesdoggg", "pattonoswalt", "meganamram"))
favs

}

}
\seealso{
\url{https://developer.twitter.com/en/docs/tweets/post-and-engage/api-reference/get-favorites-list}

Other tweets: 
\code{\link{get_mentions}()},
\code{\link{get_my_timeline}()},
\code{\link{get_timeline}()},
\code{\link{lists_statuses}()},
\code{\link{lookup_statuses}()},
\code{\link{search_tweets}()},
\code{\link{tweets_data}()},
\code{\link{tweets_with_users}()}
}
\concept{tweets}
