% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retweets.R
\name{get_retweeters}
\alias{get_retweeters}
\title{Get user IDs of users who retweeted a given status.}
\usage{
get_retweeters(status_id, n = 100, parse = TRUE, token = NULL)
}
\arguments{
\item{status_id}{required The status ID of the desired status.}

\item{n}{Specifies the number of records to retrieve.  Best if
intervals of 100.}

\item{parse}{Logical indicating whether to convert the response
object into an R list. Defaults to TRUE.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}
}
\value{
data
}
\description{
Returns user IDs of users who retweeted a given status. At the
current time, this function is limited in returning a maximum of
100 users for a given status.
}
\details{
At time of writing, pagination offers no additional
  data.
}
\seealso{
Other retweets: 
\code{\link{get_retweets}()}
}
\concept{retweets}
