% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trends.R
\name{get_trends}
\alias{get_trends}
\title{Get Twitter trends data.}
\usage{
get_trends(
  woeid = 1,
  lat = NULL,
  lng = NULL,
  exclude_hashtags = FALSE,
  token = NULL,
  parse = TRUE
)
}
\arguments{
\item{woeid}{Numeric, WOEID (Yahoo! Where On Earth ID) or character
string of desired town or country. Users may also supply latitude
and longitude coordinates to fetch the closest available trends
data given the provided location. Latitude/longitude coordinates
should be provided as WOEID value consisting of 2 numeric values
or via one latitude value and one longitude value (to the
appropriately named parameters).  To browse all available trend
places, see \code{\link{trends_available}}}

\item{lat}{Optional alternative to WOEID. Numeric, latitude in
degrees.  If two coordinates are provided for WOEID, this
function will coerce the first value to latitude.}

\item{lng}{Optional alternative to WOEID. Numeric, longitude in
degrees.  If two coordinates are provided for WOEID, this
function will coerce the second value to longitude.}

\item{exclude_hashtags}{Logical, indicating whether or not to
exclude hashtags. Defaults to FALSE--meaning, hashtags are
included in returned trends.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what `create_token()`
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
`vignettes("auth", "rtweet")` or see \code{?tokens}.}

\item{parse}{Logical, indicating whether or not to parse return
trends data. Defaults to true.}
}
\value{
Tibble data frame of trends data for a given geographical area.
}
\description{
Get Twitter trends data.
}
\examples{

\dontrun{

## Retrieve available trends
trends <- trends_available()
trends

## Store WOEID for Worldwide trends
worldwide <- trends$woeid[grep("world", trends$name, ignore.case = TRUE)[1]]

## Retrieve worldwide trends datadata
ww_trends <- get_trends(worldwide)

## Preview trends data
ww_trends

## Retrieve trends data using latitude, longitude near New York City
nyc_trends <- get_trends_closest(lat = 40.7, lng = -74.0)

## should be same result if lat/long supplied as first argument
nyc_trends <- get_trends_closest(c(40.7, -74.0))

## Preview trends data
nyc_trends

## Provide a city or location name using a regular expression string to
## have the function internals do the WOEID lookup/matching for you
(luk <- get_trends("london"))

}

}
\seealso{
Other trends: 
\code{\link{trends_available}()}
}
\concept{trends}
