% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dirch_from_allocations}
\alias{dirch_from_allocations}
\title{Given a vector of different categories in 1...n and a prior,
simulate a Dirichlet random vector}
\usage{
dirch_from_allocations(C, lambda)
}
\arguments{
\item{C}{a vector giving different categories of individual
(not counts of categories - untabulated)}

\item{lambda}{priors for the categories}
}
\description{
Takes a vector of collection indices to which individuals (vector elements) were assigned,
and returns a Dirichlet random variable generated by adding the prior to the sum
of each collection's occurrences, and simulating an alpha from a gamma distribution
with this shape parameter.
}
\details{
The categories are labeled in C from 1 up to n.  n is the length of \code{lambda},
which is a vector of priors. Note that all elements of \code{lambda}
must be strictly greater than 0.
}
\keyword{internal}
