% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packs.R
\name{data-pack}
\alias{data-pack}
\title{Data rule pack}
\description{
Data rule pack is a \link[=rule-packs]{rule pack} which defines a set of rules for
data as a whole, i.e. functions which convert data to logical values. It
should return a data frame with the following properties:
\itemize{
\item Number of rows equals to \strong{one}.
\item Column names should be treated as \strong{rule names}.
\item Values indicate whether the \strong{data as a whole} follows the rule.
}
}
\details{
This format is inspired by \code{dplyr}'s \link[dplyr:summarise]{summarise()} applied
to non-grouped data.

The most common way to define data pack is by creating a \link[magrittr:pipe]{functional
sequence} with no grouping and ending with
\code{summarise(...)}.
}
\examples{
data_dims_rules <- . \%>\%
  dplyr::summarise(nrow_low = nrow(.) > 10,
                   nrow_up = nrow(.) < 20,
                   ncol_low = ncol(.) > 5,
                   ncol_up = ncol(.) < 10)
data_na_rules <- . \%>\%
  dplyr::summarise(all_not_na = Negate(anyNA)(.))

data_packs(
  data_nrow = data_dims_rules,
  data_na = data_na_rules
)

}
\seealso{
\link[=group-pack]{Group pack}, \link[=column-pack]{Column pack}, \link[=row-pack]{row
pack}, \link[=cell-pack]{cell pack}.
}
