% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fill_run}
\alias{fill_run}
\title{Fill NA with previous non-NA element}
\usage{
fill_run(x, run_for_first = FALSE, only_within = FALSE)
}
\arguments{
\item{x}{(\code{vector}, \code{data.frame}, \code{matrix}, \code{xts})\cr
Input in runner custom function \code{f}.}

\item{run_for_first}{If first elements are filled with \code{NA}, \code{run_for_first = TRUE}
allows to fill all initial \code{NA} with nearest non-NA value. By default
\code{run_for_first = TRUE}}

\item{only_within}{\code{NA} are replaced only if previous and next non-NA
values are the same. By default \code{only_within = TRUE}}
}
\value{
vector - \code{x} containing all \code{x} elements with \code{NA}
replaced with previous non-NA element.
}
\description{
Fill \code{NA} with last non-NA element.
}
\examples{
fill_run(c(NA, NA,1:10, NA, NA), run_for_first = TRUE)
fill_run(c(NA, NA,1:10, NA, NA), run_for_first = TRUE)
fill_run(c(NA, NA,1:10, NA, NA), run_for_first = FALSE)
fill_run(c(NA, NA, 1, 2, NA, NA, 2, 2, NA, NA, 1, NA, NA), run_for_first = TRUE, only_within = TRUE)
}
