% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worker_loops.R
\name{worker_loop_callr}
\alias{worker_loop_callr}
\title{Single Task Worker Loop with callr Encapsulation}
\usage{
worker_loop_callr(fun, constants = NULL, rush)
}
\arguments{
\item{fun}{(\code{function})\cr
Function to be executed.}

\item{constants}{(\code{list})\cr
List of constants passed to \code{fun}.}

\item{rush}{(\link{RushWorker})\cr
Rush worker instance.}
}
\value{
\code{NULL}
}
\description{
Worker loop that pops a single task from the queue, executes the function in an external callr session and pushes the results.
Supports timeouts on the tasks.
}
\examples{
# This example is not executed since Redis must be installed
\donttest{
   config_local = redux::redis_config()
   rush = rsh(network_id = "test_network", config = config_local)

   fun = function(x1, x2, ...) list(y = x1 + x2)
   rush$start_local_workers(
     fun = fun,
     worker_loop = worker_loop_callr)

   rush$stop_workers()
}
}
