% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worker_loops.R
\name{worker_loop_default}
\alias{worker_loop_default}
\title{Single Task Worker Loop}
\usage{
worker_loop_default(fun, constants = NULL, rush)
}
\arguments{
\item{fun}{(\code{function})\cr
Function to be executed.}

\item{constants}{(\code{list})\cr
List of constants passed to \code{fun}.}

\item{rush}{(\link{RushWorker})\cr
Rush worker instance.}
}
\value{
\code{NULL}
}
\description{
Worker loop that pops a single task from the queue, executes the function and pushes the results.
}
\examples{
# This example is not executed since Redis must be installed
\donttest{
   config_local = redux::redis_config()
   rush = rsh(network_id = "test_network", config = config_local)

   fun = function(x1, x2, ...) list(y = x1 + x2)
   rush$start_local_workers(
     fun = fun,
     worker_loop = worker_loop_default)

   rush$stop_workers()
}
}
