% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vert_id.R
\name{vert_id}
\alias{vert_id}
\title{Search by Vertnet occurrence ID}
\usage{
vert_id(ids, compact = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{ids}{(character) VertNet IDs, one or more. Required.}

\item{compact}{(logical) Return a compact data frame. Default: \code{TRUE}}

\item{verbose}{(logical) Print progress and information messages. Default: \code{TRUE}}

\item{...}{Curl arguments passed on to \code{\link[httr]{GET}}}
}
\value{
A list, with data frame of search results, and list of metadata
}
\description{
Search by Vertnet occurrence ID
}
\examples{
\dontrun{
vert_id(ids = "urn:occurrence:Arctos:CUMV:Amph:10008:2243441")
ids <- c("urn:occurrence:Arctos:CUMV:Amph:10008:2243441", 
         "urn:occurrence:Arctos:CUMV:Fish:65813:2206324",
         "urn:catalog:AUM:Fish:13271")
res <- vert_id(ids)
res$data$occurrenceid
identical(sort(res$data$occurrenceid), sort(ids))

# Lots
out <- vertsearch(taxon = "aves", state = "california", limit = 20)
ids <- out$data$occurrenceid
res <- vert_id(ids)
identical(sort(res$data$occurrenceid), sort(ids))
}
}
\references{
\url{http://bit.ly/vertnet-wiki}
}

