% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vert_id.R
\name{vert_id}
\alias{vert_id}
\title{Search by Vertnet occurrence ID}
\usage{
vert_id(ids, compact = TRUE, messages = TRUE, ...)
}
\arguments{
\item{ids}{(character) VertNet IDs, one or more. Required.}

\item{compact}{(logical) Return a compact data frame. That is, remove
empty columns. Default: \code{TRUE}}

\item{messages}{(logical) Print progress and information messages. 
Default: \code{TRUE}}

\item{...}{Curl arguments passed on to \code{\link[crul]{HttpClient}}}
}
\value{
A list, with data frame of search results, and list of metadata
}
\description{
Search by Vertnet occurrence ID
}
\details{
VertNet IDs can be a variety of things, some URIs 
(i.e., with http://...), while others start with \code{urn}.
}
\examples{
\dontrun{
vert_id(ids = "urn:catalog:CM:Herps:116520")
ids <- c("http://arctos.database.museum/guid/MSB:Mamm:56979?seid=1643089", 
         "urn:catalog:CM:Herps:116520",
         "urn:catalog:AUM:Fish:13271")
res <- vert_id(ids)
res$data$occurrenceid

# Lots
out <- vertsearch(taxon = "aves", state = "california", limit = 20)
(ids <- out$data$occurrenceid)
res <- vert_id(ids)
identical(sort(res$data$occurrenceid), sort(ids))
}
}
\references{
\url{http://bit.ly/vertnet-wiki}
}
