% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_with_vg.R
\name{dml}
\alias{dml}
\title{Wrap plot instructions for DrawingML plotting in Powerpoint}
\usage{
dml(code, ggobj = NULL, bg = "white", fonts = list(),
  pointsize = 12, editable = TRUE, ...)
}
\arguments{
\item{code}{plotting instructions}

\item{ggobj}{ggplot object to print. argument code will be ignored if this
argument is supplied.}

\item{bg, fonts, pointsize, editable}{Parameters passed to \code{\link{dml_pptx}}}

\item{...}{unused arguments}
}
\description{
A simple wrapper to mark
the plot instructions as Vector Graphics instructions. It produces
an object of class 'dml' with a corresponding method \code{\link[officer]{ph_with}}.

The function enable usage of any R plot with argument \code{code} and with
ggplot objects with argument \code{ggobj}.
}
\examples{
anyplot = dml(code = barplot(1:5, col = 2:6), bg = "wheat")

library(officer)
doc <- read_pptx()
doc <- add_slide(doc, "Title and Content", "Office Theme")
doc <- ph_with(doc, anyplot, location = ph_location_fullsize())
fileout <- tempfile(fileext = ".pptx")
# fileout <- "vg.pptx"
print(doc, target = fileout)
}
\seealso{
\code{\link{ph_with.dml}}
}
