% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vine_methods.R
\name{vine_distributions}
\alias{vine_distributions}
\alias{dvine}
\alias{pvine}
\alias{rvine}
\alias{dvine_dist}
\alias{pvine_dist}
\alias{rvine_dist}
\alias{pvine}
\alias{rvine}
\title{Vine based distributions}
\usage{
dvine(x, vine)

pvine(x, vine, n_mc = 10^4)

rvine(n, vine, U = NULL)
}
\arguments{
\item{x}{evaluation points, either a length d vector or a d-column matrix,
where d is the number of variables in the vine.}

\item{vine}{an object of class \code{"vine_dist"}.}

\item{n_mc}{number of samples used for quasi Monte Carlo integration.}

\item{n}{number of observations.}

\item{U}{optionally, an \eqn{n \times d} matrix of values in \eqn{(0,1)}.
The result is then the inverse Rosenblatt transform of \code{U}; if \code{U} is a
matrix of independent \eqn{U(0, 1)} variables, this simulates data
from \code{vine}.}
}
\value{
\code{dvine()} gives the density, \code{pvine()} gives the distribution function,
and \code{rvine()} generates random deviates.

The length of the result is determined by \code{n} for \code{rvine()}, and
the number of rows in \code{u} for the other functions.

The \code{vine} object is recycled to the length of the
result.
}
\description{
Density, distribution function and random generation
for the vine based distribution.
}
\details{
See \link{vine} for the estimation and construction of vine models.
Here, the density, distribution function and random generation
for the vine distributions are standard.

The functions are based on \code{\link[=dvinecop]{dvinecop()}}, \code{\link[=pvinecop]{pvinecop()}} and \code{\link[=rvinecop]{rvinecop()}} for
\link{vinecop} objects, and either \code{\link[kde1d:dkde1d]{kde1d::dkde1d()}}, \code{\link[kde1d:pkde1d]{kde1d::pkde1d()}} and
\code{\link[kde1d:qkde1d]{kde1d::qkde1d()}} for estimated vines (i.e., output of \code{\link[=vine]{vine()}}), or the
standard \emph{d/p/q-xxx} from \link[stats:Distributions]{stats::Distributions} for customly created vines
(i.e., output of \code{\link[=vine_dist]{vine_dist()}})
}
\examples{
# specify pair-copulas
bicop <- bicop_dist("bb1", 90, c(3, 2))
pcs <- list(
    list(bicop, bicop),  # pair-copulas in first tree 
    list(bicop)          # pair-copulas in second tree 
 )
 
# specify R-vine matrix
mat <- matrix(c(1, 2, 3, 1, 2, 0, 1, 0, 0), 3, 3) 

# set up vine copula model
vc <- vine_dist(list(name = "norm"), pcs, mat)

# simulate from the model
x <- rvine(200, vc)
pairs(x)

# evaluate the density and cdf
dvine(x[1, ], vc)
pvine(x[1, ], vc)
}
