% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vinecop_methods.R
\name{vinecop_distributions}
\alias{vinecop_distributions}
\alias{dvinecop}
\alias{pvinecop}
\alias{rvinecop}
\alias{dvinecop_dist}
\alias{pvinecop_dist}
\alias{rvinecop_dist}
\title{Vine copula distributions}
\usage{
dvinecop(u, vinecop, cores = 1)

pvinecop(u, vinecop, n_mc = 10^4, cores = 1)

rvinecop(n, vinecop, qrng = FALSE, cores = 1)
}
\arguments{
\item{u}{matrix of evaluation points; must contain at least d columns, where
d is the number of variables in the vine. More columns are required for
discrete models, see \emph{Details}.}

\item{vinecop}{an object of class \code{"vinecop_dist"}.}

\item{cores}{number of cores to use; if larger than one, computations are
done in parallel on \code{cores} batches .}

\item{n_mc}{number of samples used for quasi Monte Carlo integration.}

\item{n}{number of observations.}

\item{qrng}{if \code{TRUE}, generates quasi-random numbers using the multivariate
Generalized Halton sequence up to dimension 300 and the Generalized Sobol
sequence in higher dimensions (default \code{qrng = FALSE}).}
}
\value{
\code{dvinecop()} gives the density, \code{pvinecop()} gives the distribution function,
and \code{rvinecop()} generates random deviates.

The length of the result is determined by \code{n} for \code{rvinecop()}, and
the number of rows in \code{u} for the other functions.

The \code{vinecop} object is recycled to the length of the
result.
}
\description{
Density, distribution function and random generation for the vine copula
distribution.
}
\details{
See \code{\link[=vinecop]{vinecop()}} for the estimation and construction of vine copula
models.

The copula density is defined as joint density divided by marginal
densities, irrespective of variable types.
\subsection{Discrete variables}{

When at least one variable is discrete, two types of
"observations" are required in \code{u}: the first \eqn{n \; x \; d} block
contains realizations of \eqn{F_{X_j}(X_j)}. The second \eqn{n \; x \; d}
block contains realizations of \eqn{F_{X_j}(X_j^-)}. The minus indicates a
left-sided limit of the cdf. For, e.g., an integer-valued variable, it holds
\eqn{F_{X_j}(X_j^-) = F_{X_j}(X_j - 1)}. For continuous variables the left
limit and the cdf itself coincide. Respective columns can be omitted in the
second block.
}
}
\examples{
## simulate dummy data
x <- rnorm(30) * matrix(1, 30, 5) + 0.5 * matrix(rnorm(30 * 5), 30, 5)
u <- pseudo_obs(x)

## fit a model
vc <- vinecop(u, family = "clayton")

# simulate from the model
u <- rvinecop(100, vc)
pairs(u)

# evaluate the density and cdf
dvinecop(u[1, ], vc)
pvinecop(u[1, ], vc)

## Discrete models
vc$var_types <- rep("d", 5)  # convert model to discrete

# with discrete data we need two types of observations (see Details)
x <- qpois(u, 1)  # transform to Poisson margins
u_disc <- cbind(ppois(x, 1), ppois(x - 1, 1))

dvinecop(u_disc[1:5, ], vc)
pvinecop(u_disc[1:5, ], vc)

# simulated data always has uniform margins
pairs(rvinecop(200, vc))
}
\seealso{
\code{\link[=vinecop_dist]{vinecop_dist()}}, \code{\link[=vinecop]{vinecop()}}, \code{\link[=plot.vinecop]{plot.vinecop()}}, \code{\link[=contour.vinecop]{contour.vinecop()}}
}
