% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HardThresh.R
\name{HardThresh}
\alias{HardThresh}
\title{Apply Hard Threshold.}
\usage{
HardThresh(y, t)
}
\arguments{
\item{y}{Noisy Data.}

\item{t}{Threshold.}
}
\value{
\code{x} filtered result (y 1_{|y|>t}).
}
\description{
Apply Hard Threshold.
}
\examples{
f <- MakeSignal('HeaviSine',2^3)
qmf <- MakeONFilter('Daubechies', 10)
L <- 0
wc <- FWT_PO(f, L, qmf)
thr <- 2
wct <- HardThresh(wc, thr)
fhard <- IWT_PO(wct, L, qmf)
}
