% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxsolve.R
\name{rxSolve}
\alias{rxSolve}
\alias{rxSolve.function}
\alias{rxSolve.rxUi}
\alias{rxSolve.nlmixr2FitData}
\alias{rxSolve.nlmixr2FitCore}
\alias{rxSolve.default}
\alias{update.rxSolve}
\alias{predict.rxode2}
\alias{predict.rxSolve}
\alias{predict.rxEt}
\alias{predict.rxParams}
\alias{simulate.rxode2}
\alias{simulate.rxSolve}
\alias{simulate.rxParams}
\alias{solve.rxSolve}
\alias{solve.rxUi}
\alias{solve.function}
\alias{solve.rxode2}
\alias{solve.rxParams}
\alias{solve.rxEt}
\alias{rxControl}
\title{Solving & Simulation of a ODE/solved system (a options) equation}
\usage{
rxSolve(
  object,
  params = NULL,
  events = NULL,
  inits = NULL,
  scale = NULL,
  method = c("liblsoda", "lsoda", "dop853", "indLin"),
  sigdig = NULL,
  atol = 1e-08,
  rtol = 1e-06,
  maxsteps = 70000L,
  hmin = 0,
  hmax = NA_real_,
  hmaxSd = 0,
  hini = 0,
  maxordn = 12L,
  maxords = 5L,
  ...,
  cores,
  covsInterpolation = c("locf", "linear", "nocb", "midpoint"),
  addCov = TRUE,
  sigma = NULL,
  sigmaDf = NULL,
  sigmaLower = -Inf,
  sigmaUpper = Inf,
  nCoresRV = 1L,
  sigmaIsChol = FALSE,
  sigmaSeparation = c("auto", "lkj", "separation"),
  sigmaXform = c("identity", "variance", "log", "nlmixrSqrt", "nlmixrLog",
    "nlmixrIdentity"),
  nDisplayProgress = 10000L,
  amountUnits = NA_character_,
  timeUnits = "hours",
  theta = NULL,
  thetaLower = -Inf,
  thetaUpper = Inf,
  eta = NULL,
  addDosing = FALSE,
  stateTrim = Inf,
  updateObject = FALSE,
  omega = NULL,
  omegaDf = NULL,
  omegaIsChol = FALSE,
  omegaSeparation = c("auto", "lkj", "separation"),
  omegaXform = c("variance", "identity", "log", "nlmixrSqrt", "nlmixrLog",
    "nlmixrIdentity"),
  omegaLower = -Inf,
  omegaUpper = Inf,
  nSub = 1L,
  thetaMat = NULL,
  thetaDf = NULL,
  thetaIsChol = FALSE,
  nStud = 1L,
  dfSub = 0,
  dfObs = 0,
  returnType = c("rxSolve", "matrix", "data.frame", "data.frame.TBS", "data.table",
    "tbl", "tibble"),
  seed = NULL,
  nsim = NULL,
  minSS = 10L,
  maxSS = 1000L,
  infSSstep = 12,
  strictSS = TRUE,
  istateReset = TRUE,
  subsetNonmem = TRUE,
  maxAtolRtolFactor = 0.1,
  from = NULL,
  to = NULL,
  by = NULL,
  length.out = NULL,
  iCov = NULL,
  keep = NULL,
  indLinPhiTol = 1e-07,
  indLinPhiM = 0L,
  indLinMatExpType = c("expokit", "Al-Mohy", "arma"),
  indLinMatExpOrder = 6L,
  drop = NULL,
  idFactor = TRUE,
  mxhnil = 0,
  hmxi = 0,
  warnIdSort = TRUE,
  warnDrop = TRUE,
  ssAtol = 1e-08,
  ssRtol = 1e-06,
  safeZero = TRUE,
  sumType = c("pairwise", "fsum", "kahan", "neumaier", "c"),
  prodType = c("long double", "double", "logify"),
  sensType = c("advan", "autodiff", "forward", "central"),
  linDiff = c(tlag = 1.5e-05, f = 1.5e-05, rate = 1.5e-05, dur = 1.5e-05, tlag2 =
    1.5e-05, f2 = 1.5e-05, rate2 = 1.5e-05, dur2 = 1.5e-05),
  linDiffCentral = c(tlag = TRUE, f = TRUE, rate = TRUE, dur = TRUE, tlag2 = TRUE, f2 =
    TRUE, rate2 = TRUE, dur2 = TRUE),
  resample = NULL,
  resampleID = TRUE,
  maxwhile = 1e+05,
  atolSens = 1e-08,
  rtolSens = 1e-06,
  ssAtolSens = 1e-08,
  ssRtolSens = 1e-06,
  simVariability = NA,
  nLlikAlloc = NULL,
  useStdPow = FALSE
)

\method{rxSolve}{`function`}(
  object,
  params = NULL,
  events = NULL,
  inits = NULL,
  ...,
  theta = NULL,
  eta = NULL
)

\method{rxSolve}{rxUi}(
  object,
  params = NULL,
  events = NULL,
  inits = NULL,
  ...,
  theta = NULL,
  eta = NULL
)

\method{rxSolve}{nlmixr2FitData}(
  object,
  params = NULL,
  events = NULL,
  inits = NULL,
  ...,
  theta = NULL,
  eta = NULL
)

\method{rxSolve}{nlmixr2FitCore}(
  object,
  params = NULL,
  events = NULL,
  inits = NULL,
  ...,
  theta = NULL,
  eta = NULL
)

\method{rxSolve}{default}(
  object,
  params = NULL,
  events = NULL,
  inits = NULL,
  ...,
  theta = NULL,
  eta = NULL
)

\method{update}{rxSolve}(object, ...)

\method{predict}{rxode2}(object, ...)

\method{predict}{rxSolve}(object, ...)

\method{predict}{rxEt}(object, ...)

\method{predict}{rxParams}(object, ...)

\method{simulate}{rxode2}(object, nsim = 1L, seed = NULL, ...)

\method{simulate}{rxSolve}(object, nsim = 1L, seed = NULL, ...)

\method{simulate}{rxParams}(object, nsim = 1L, seed = NULL, ...)

\method{solve}{rxSolve}(a, b, ...)

\method{solve}{rxUi}(a, b, ...)

\method{solve}{`function`}(a, b, ...)

\method{solve}{rxode2}(a, b, ...)

\method{solve}{rxParams}(a, b, ...)

\method{solve}{rxEt}(a, b, ...)

rxControl(..., params = NULL, events = NULL, inits = NULL)
}
\arguments{
\item{object}{is a either a rxode2 family of objects, or a file-name
with a rxode2 model specification, or a string with a rxode2
model specification.}

\item{params}{a numeric named vector with values for every
parameter in the ODE system; the names must correspond to the
parameter identifiers used in the ODE specification;}

\item{events}{an \code{eventTable} object describing the input
(e.g., doses) to the dynamic system and observation sampling
time points (see \code{\link[=eventTable]{eventTable()}});}

\item{inits}{a vector of initial values of the state variables
(e.g., amounts in each compartment), and the order in this
vector must be the same as the state variables (e.g., PK/PD
compartments);}

\item{scale}{a numeric named vector with scaling for ode
parameters of the system.  The names must correspond to the
parameter identifiers in the ODE specification. Each of the
ODE variables will be divided by the scaling factor.  For
example \code{scale=c(center=2)} will divide the center ODE
variable by 2.}

\item{method}{The method for solving ODEs.  Currently this supports:
\itemize{
\item \code{"liblsoda"} thread safe lsoda.  This supports parallel
thread-based solving, and ignores user Jacobian specification.
\item \code{"lsoda"} -- LSODA solver.  Does not support parallel thread-based
solving, but allows user Jacobian specification.
\item \code{"dop853"} -- DOP853 solver.  Does not support parallel thread-based
solving nor user Jacobian specification
\item \code{"indLin"} -- Solving through inductive linearization.  The rxode2 dll
must be setup specially to use this solving routine.
}}

\item{sigdig}{Specifies the "significant digits" that the ode
solving requests.  When specified this controls the relative and
absolute tolerances of the ODE solvers.  By default the tolerance
is \code{0.5*10^(-sigdig-2)} for regular ODEs. For the
sensitivity equations the default is \code{0.5*10^(-sigdig-1.5)}
(sensitivity changes only applicable for liblsoda).  This also
controls the \code{atol}/\code{rtol} of the steady state solutions. The
\code{ssAtol}/\code{ssRtol} is \code{0.5*10^(-sigdig)} and for the sensitivities
\code{0.5*10^(-sigdig+0.625)}.  By default
this is unspecified (\code{NULL}) and uses the standard \code{atol}/\code{rtol}.}

\item{atol}{a numeric absolute tolerance (1e-8 by default) used
by the ODE solver to determine if a good solution has been
achieved;  This is also used in the solved linear model to check
if prior doses do not add anything to the solution.}

\item{rtol}{a numeric relative tolerance (\code{1e-6} by default) used
by the ODE solver to determine if a good solution has been
achieved. This is also used in the solved linear model to check
if prior doses do not add anything to the solution.}

\item{maxsteps}{maximum number of (internally defined) steps allowed
during one call to the solver. (5000 by default)}

\item{hmin}{The minimum absolute step size allowed. The default
value is 0.}

\item{hmax}{The maximum absolute step size allowed.  When
\code{hmax=NA} (default), uses the average difference +
hmaxSd*sd in times and sampling events. The \code{hmaxSd} is a user
specified parameter and which defaults to zero.  When
\code{hmax=NULL} rxode2 uses the maximum difference in times in
your sampling and events.  The value 0 is equivalent to infinite
maximum absolute step size.}

\item{hmaxSd}{The number of standard deviations of the time
difference to add to hmax. The default is 0}

\item{hini}{The step size to be attempted on the first step. The
default value is determined by the solver (when \code{hini = 0})}

\item{maxordn}{The maximum order to be allowed for the nonstiff
(Adams) method.  The default is 12.  It can be between 1 and
12.}

\item{maxords}{The maximum order to be allowed for the stiff (BDF)
method.  The default value is 5.  This can be between 1 and 5.}

\item{...}{Other arguments including scaling factors for each
compartment.  This includes S# = numeric will scale a compartment
# by a dividing the compartment amount by the scale factor,
like NONMEM.}

\item{cores}{Number of cores used in parallel ODE solving.  This
is equivalent to calling \code{\link[=setRxThreads]{setRxThreads()}}}

\item{covsInterpolation}{specifies the interpolation method for
time-varying covariates. When solving ODEs it often samples
times outside the sampling time specified in \code{events}.
When this happens, the time varying covariates are
interpolated.  Currently this can be:
\itemize{
\item \code{"linear"} interpolation, which interpolates the covariate
by solving the line between the observed covariates and extrapolating the new
covariate value.
\item \code{"constant"} -- Last observation carried forward (the default).
\item \code{"NOCB"} -- Next Observation Carried Backward.  This is the same method
that NONMEM uses.
\item \code{"midpoint"} Last observation carried forward to midpoint; Next observation
carried backward to midpoint.
}}

\item{addCov}{A boolean indicating if covariates should be added
to the output matrix or data frame. By default this is
disabled.}

\item{sigma}{Named sigma covariance or Cholesky decomposition of a
covariance matrix.  The names of the columns indicate
parameters that are simulated.  These are simulated for every
observation in the solved system. When \code{sigma} is \code{NA} and you are using it with a
\code{rxode2} ui model, the unexplained variability described by
the \code{sigma} matrix are set to zero.}

\item{sigmaDf}{Degrees of freedom of the sigma t-distribution.  By
default it is equivalent to \code{Inf}, or a normal distribution.}

\item{sigmaLower}{Lower bounds for simulated unexplained variability (by default -Inf)}

\item{sigmaUpper}{Upper bounds for simulated unexplained variability (by default Inf)}

\item{nCoresRV}{Number of cores used for the simulation of the
sigma variables.  By default this is 1. To reproduce the results
you need to run on the same platform with the same number of
cores. This is the reason this is set to be one, regardless of
what the number of cores are used in threaded ODE solving.}

\item{sigmaIsChol}{Boolean indicating if the sigma is in the
Cholesky decomposition instead of a symmetric covariance}

\item{sigmaSeparation}{separation strategy for sigma;

Tells the type of separation strategy when
simulating covariance with parameter uncertainty with standard
deviations modeled in the \code{thetaMat} matrix.
\itemize{
\item \code{"lkj"} simulates the correlation matrix from the
\code{rLKJ1} matrix with the distribution parameter \code{eta}
equal to the degrees of freedom \code{nu} by \code{(nu-1)/2}
\item \code{"separation"} simulates from the identity inverse Wishart
covariance matrix with \code{nu} degrees of freedom.  This is then
converted to a covariance matrix and augmented with the modeled
standard deviations.  While computationally more complex than the
\code{"lkj"} prior, it performs better when the covariance matrix
size is greater or equal to 10
\item \code{"auto"} chooses \code{"lkj"} when the dimension of the
matrix is less than 10 and \code{"separation"} when greater
than equal to 10.
}}

\item{sigmaXform}{When taking \code{sigma} values from the \code{thetaMat}
simulations (using the separation strategy for covariance
simulation), how should the \code{thetaMat} values be turned int
standard deviation values:
\itemize{
\item \code{identity} This is when standard deviation values are
directly modeled by the \code{params} and \code{thetaMat} matrix
\item \code{variance} This is when the \code{params} and \code{thetaMat}
simulates the variance that are directly modeled by the
\code{thetaMat} matrix
\item \code{log} This is when the \code{params} and \code{thetaMat}
simulates \code{log(sd)}
\item \code{nlmixrSqrt} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix
with the \code{x^2} modeled along the diagonal.  This only works
with a diagonal matrix.
\item \code{nlmixrLog} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix
with the \code{exp(x^2)} along the diagonal.  This only works
with a diagonal matrix.
\item \code{nlmixrIdentity} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix.
This only works with a diagonal matrix.
}}

\item{nDisplayProgress}{An integer indicating the minimum number
of c-based solves before a progress bar is shown.  By default
this is 10,000.}

\item{amountUnits}{This supplies the dose units of a data frame
supplied instead of an event table.  This is for importing the
data as an rxode2 event table.}

\item{timeUnits}{This supplies the time units of a data frame
supplied instead of an event table.  This is for importing the
data as an rxode2 event table.}

\item{theta}{A vector of parameters that will be named \verb{THETA\[#\]} and
added to parameters}

\item{thetaLower}{Lower bounds for simulated population parameter
variability (by default \code{-Inf})}

\item{thetaUpper}{Upper bounds for simulated population unexplained
variability (by default \code{Inf})}

\item{eta}{A vector of parameters that will be named \verb{ETA\[#\]} and
added to parameters}

\item{addDosing}{Boolean indicating if the solve should add rxode2
EVID and related columns.  This will also include dosing
information and estimates at the doses.  Be default, rxode2
only includes estimates at the observations. (default
\code{FALSE}). When \code{addDosing} is \code{NULL}, only
include \code{EVID=0} on solve and exclude any model-times or
\code{EVID=2}. If \code{addDosing} is \code{NA} the classic
\code{rxode2} EVID events are returned. When \code{addDosing} is \code{TRUE}
add the event information in NONMEM-style format; If
\code{subsetNonmem=FALSE} rxode2 will also include extra event types
(\code{EVID}) for ending infusion and modeled times:
\itemize{
\item \code{EVID=-1} when the modeled rate infusions are turned
off (matches \code{rate=-1})
\item \code{EVID=-2} When the modeled duration infusions are
turned off (matches \code{rate=-2})
\item \code{EVID=-10} When the specified \code{rate} infusions are
turned off (matches \code{rate>0})
\item \code{EVID=-20} When the specified \code{dur} infusions are
turned off (matches \code{dur>0})
\item \verb{EVID=101,102,103,...} Modeled time where 101 is the
first model time, 102 is the second etc.
}}

\item{stateTrim}{When amounts/concentrations in one of the states
are above this value, trim them to be this value. By default
Inf.  Also trims to -stateTrim for large negative
amounts/concentrations.  If you want to trim between a range
say \code{c(0, 2000000)} you may specify 2 values with a lower and
upper range to make sure all state values are in the
reasonable range.}

\item{updateObject}{This is an internally used flag to update the
rxode2 solved object (when supplying an rxode2 solved object) as
well as returning a new object.  You probably should not
modify it's \code{FALSE} default unless you are willing to
have unexpected results.}

\item{omega}{Estimate of Covariance matrix. When omega is a list,
assume it is a block matrix and convert it to a full matrix for
simulations.  When \code{omega} is \code{NA} and you are using it with a
\code{rxode2} ui model, the between subject variability described by
the \code{omega} matrix are set to zero.}

\item{omegaDf}{The degrees of freedom of a t-distribution for
simulation.  By default this is \code{NULL} which is
equivalent to \code{Inf} degrees, or to simulate from a normal
distribution instead of a t-distribution.}

\item{omegaIsChol}{Indicates if the \code{omega} supplied is a
Cholesky decomposed matrix instead of the traditional
symmetric matrix.}

\item{omegaSeparation}{Omega separation strategy

Tells the type of separation strategy when
simulating covariance with parameter uncertainty with standard
deviations modeled in the \code{thetaMat} matrix.
\itemize{
\item \code{"lkj"} simulates the correlation matrix from the
\code{rLKJ1} matrix with the distribution parameter \code{eta}
equal to the degrees of freedom \code{nu} by \code{(nu-1)/2}
\item \code{"separation"} simulates from the identity inverse Wishart
covariance matrix with \code{nu} degrees of freedom.  This is then
converted to a covariance matrix and augmented with the modeled
standard deviations.  While computationally more complex than the
\code{"lkj"} prior, it performs better when the covariance matrix
size is greater or equal to 10
\item \code{"auto"} chooses \code{"lkj"} when the dimension of the
matrix is less than 10 and \code{"separation"} when greater
than equal to 10.
}}

\item{omegaXform}{When taking \code{omega} values from the \code{thetaMat}
simulations (using the separation strategy for covariance
simulation), how should the \code{thetaMat} values be turned int
standard deviation values:
\itemize{
\item \code{identity} This is when standard deviation values are
directly modeled by the \code{params} and \code{thetaMat} matrix
\item \code{variance} This is when the \code{params} and \code{thetaMat}
simulates the variance that are directly modeled by the
\code{thetaMat} matrix
\item \code{log} This is when the \code{params} and \code{thetaMat}
simulates \code{log(sd)}
\item \code{nlmixrSqrt} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix
with the \code{x^2} modeled along the diagonal.  This only works
with a diagonal matrix.
\item \code{nlmixrLog} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix
with the \code{exp(x^2)} along the diagonal.  This only works
with a diagonal matrix.
\item \code{nlmixrIdentity} This is when the \code{params} and
\code{thetaMat} simulates the inverse cholesky decomposed matrix.
This only works with a diagonal matrix.
}}

\item{omegaLower}{Lower bounds for simulated ETAs (by default -Inf)}

\item{omegaUpper}{Upper bounds for simulated ETAs (by default Inf)}

\item{nSub}{Number between subject variabilities (\code{ETAs}) simulated for every
realization of the parameters.}

\item{thetaMat}{Named theta matrix.}

\item{thetaDf}{The degrees of freedom of a t-distribution for
simulation.  By default this is \code{NULL} which is
equivalent to \code{Inf} degrees, or to simulate from a normal
distribution instead of a \code{t}-distribution.}

\item{thetaIsChol}{Indicates if the \code{theta} supplied is a
Cholesky decomposed matrix instead of the traditional
symmetric matrix.}

\item{nStud}{Number virtual studies to characterize uncertainty in estimated
parameters.}

\item{dfSub}{Degrees of freedom to sample the between subject variability matrix from the
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{dfObs}{Degrees of freedom to sample the unexplained variability matrix from the
inverse Wishart distribution (scaled) or scaled inverse chi squared distribution.}

\item{returnType}{This tells what type of object is returned.  The
currently supported types are:
\itemize{
\item \code{"rxSolve"} (default) will return a reactive data frame
that can change easily change different pieces of the solve and
update the data frame.  This is the currently standard solving
method in rxode2,  is used for \code{rxSolve(object, ...)}, \code{solve(object,...)},
\item \code{"data.frame"} -- returns a plain, non-reactive data
frame; Currently very slightly faster than \code{returnType="matrix"}
\item \code{"matrix"} -- returns a plain matrix with column names attached
to the solved object.  This is what is used \code{object$run} as well as \code{object$solve}
\item \code{"data.table"} -- returns a \code{data.table}; The \code{data.table} is
created by reference (ie \code{setDt()}), which should be fast.
\item \code{"tbl"} or \code{"tibble"} returns a tibble format.
}}

\item{seed}{an object specifying if and how the random number
generator should be initialized}

\item{nsim}{represents the number of simulations.  For rxode2, if
you supply single subject event tables (created with
\verb{[eventTable()]})}

\item{minSS}{Minimum number of iterations for a steady-state dose}

\item{maxSS}{Maximum number of iterations for a steady-state dose}

\item{infSSstep}{Step size for determining if a constant infusion
has reached steady state.  By default this is large value,
12.}

\item{strictSS}{Boolean indicating if a strict steady-state is
required. If a strict steady-state is (\code{TRUE}) required
then at least \code{minSS} doses are administered and the
total number of steady states doses will continue until
\code{maxSS} is reached, or \code{atol} and \code{rtol} for
every compartment have been reached.  However, if ODE solving
problems occur after the \code{minSS} has been reached the
whole subject is considered an invalid solve. If
\code{strictSS} is \code{FALSE} then as long as \code{minSS}
has been reached the last good solve before ODE solving
problems occur is considered the steady state, even though
either \code{atol}, \code{rtol} or \code{maxSS} have not
been achieved.}

\item{istateReset}{When \code{TRUE}, reset the \code{ISTATE} variable to 1 for
lsoda and liblsoda with doses, like \code{deSolve}; When \code{FALSE}, do
not reset the \code{ISTATE} variable with doses.}

\item{subsetNonmem}{subset to NONMEM compatible EVIDs only.  By
default \code{TRUE}.}

\item{maxAtolRtolFactor}{The maximum \code{atol}/\code{rtol} that
FOCEi and other routines may adjust to.  By default 0.1}

\item{from}{When there is no observations in the event table,
start observations at this value. By default this is zero.}

\item{to}{When there is no observations in the event table, end
observations at this value. By default this is 24 + maximum
dose time.}

\item{by}{When there are no observations in the event table, this
is the amount to increment for the observations between \code{from}
and \code{to}.}

\item{length.out}{The number of observations to create if there
isn't any observations in the event table. By default this is 200.}

\item{iCov}{A data frame of individual non-time varying covariates
to combine with the \code{events} dataset by merge.}

\item{keep}{Columns to keep from either the input dataset or the
\code{iCov} dataset.  With the \code{iCov} dataset, the column
is kept once per line.  For the input dataset, if any records
are added to the data LOCF (Last Observation Carried forward)
imputation is performed.}

\item{indLinPhiTol}{the requested accuracy tolerance on
exponential matrix.}

\item{indLinPhiM}{the maximum size for the Krylov basis}

\item{indLinMatExpType}{This is them matrix exponential type that
is use for rxode2.  Currently the following are supported:
\itemize{
\item \code{Al-Mohy} Uses the exponential matrix method of Al-Mohy Higham (2009)
\item \code{arma} Use the exponential matrix from RcppArmadillo
\item \code{expokit} Use the exponential matrix from Roger B. Sidje (1998)
}}

\item{indLinMatExpOrder}{an integer, the order of approximation to
be used, for the \code{Al-Mohy} and \code{expokit} values.
The best value for this depends on machine precision (and
slightly on the matrix). We use \code{6} as a default.}

\item{drop}{Columns to drop from the output}

\item{idFactor}{This boolean indicates if original ID values
should be maintained. This changes the default sequentially
ordered ID to a factor with the original ID values in the
original dataset.  By default this is enabled.}

\item{mxhnil}{maximum number of messages printed (per problem)
warning that \code{T + H = T} on a step (\code{H} = step size).  This must
be positive to result in a non-default value.  The default
value is 0 (or infinite).}

\item{hmxi}{inverse of the maximum absolute value of \code{H} to are used.
hmxi = 0.0 is allowed and corresponds to an infinite \verb{hmax1 (default).  }hmin\code{and}hmxi\verb{may be changed at any time, but will not take effect until the next change of}H\verb{is considered. This option is only considered with}method="liblsoda"`.}

\item{warnIdSort}{Warn if the ID is not present and rxode2 assumes
the order of the parameters/iCov are the same as the order of
the parameters in the input dataset.}

\item{warnDrop}{Warn if column(s) were supposed to be dropped, but
were not present.}

\item{ssAtol}{Steady state atol convergence factor.  Can be
a vector based on each state.}

\item{ssRtol}{Steady state rtol convergence factor.  Can be a
vector based on each state.}

\item{safeZero}{Use safe zero divide and log routines.  By default
this is turned on but you may turn it off if you wish.}

\item{sumType}{Sum type to use for \code{sum()} in
rxode2 code blocks.

\code{pairwise} uses the pairwise sum (fast, default)

\code{fsum} uses the PreciseSum package's fsum function (most accurate)

\code{kahan} uses Kahan correction

\code{neumaier} uses Neumaier correction

\code{c} uses no correction: default/native summing}

\item{prodType}{Product to use for \code{prod()} in rxode2 blocks

\verb{long double} converts to long double, performs the
multiplication and then converts back.

\code{double} uses the standard double scale for multiplication.}

\item{sensType}{Sensitivity type for \code{linCmt()} model:

\code{advan} Use the direct advan solutions

\code{autodiff} Use the autodiff advan solutions

\code{forward} Use forward difference solutions

\code{central} Use central differences}

\item{linDiff}{This gives the linear difference amount for all the
types of linear compartment model parameters where sensitivities
are not calculated. The named components of this numeric vector are:
\itemize{
\item \code{"lag"} Central compartment lag
\item \code{"f"} Central compartment bioavailability
\item \code{"rate"} Central compartment modeled rate
\item \code{"dur"} Central compartment modeled duration
\item \code{"lag2"} Depot compartment lag
\item \code{"f2"} Depot compartment bioavailability
\item \code{"rate2"} Depot compartment modeled rate
\item \code{"dur2"} Depot compartment modeled duration
}}

\item{linDiffCentral}{This gives the which parameters use central
differences for the linear compartment model parameters.  The
are the same components as \code{linDiff}}

\item{resample}{A character vector of model variables to resample
from the input dataset; This sampling is done with replacement.
When \code{NULL} or \code{FALSE} no resampling is done.  When
\code{TRUE} resampling is done on all covariates in the input
dataset}

\item{resampleID}{boolean representing if the resampling should be
done on an individual basis \code{TRUE} (ie. a whole patient is
selected) or each covariate is resampled independent of the
subject identifier \code{FALSE}.  When \code{resampleID=TRUE}
correlations of parameters are retained, where as when
\code{resampleID=FALSE} ignores patient covariate correaltions.
Hence the default is \code{resampleID=TRUE}.}

\item{maxwhile}{represents the maximum times a while loop is
evaluated before exiting.  By default this is 100000}

\item{atolSens}{Sensitivity atol, can be different than atol with
liblsoda.  This allows a less accurate solve for gradients (if desired)}

\item{rtolSens}{Sensitivity rtol, can be different than rtol with
liblsoda.  This allows a less accurate solve for gradients (if desired)}

\item{ssAtolSens}{Sensitivity absolute tolerance (atol) for
calculating if steady state has been achieved for sensitivity compartments.}

\item{ssRtolSens}{Sensitivity relative tolerance (rtol) for
calculating if steady state has been achieved for sensitivity compartments.}

\item{simVariability}{determines if the variability is simulated.
When \code{NA} (default) this is determined by the solver.}

\item{nLlikAlloc}{The number of log likelihood endpoints that are
used in the model.  This allows independent log likelihood per
endpoint in focei for nlmixr2.  It likely shouldn't be set,
though it won't hurt anything if you do (just may take up more
memory for larger allocations).}

\item{useStdPow}{This uses C's \code{pow} for exponentiation instead of
R's \code{R_pow} or \code{R_pow_di}.  By default this is \code{FALSE}}

\item{a}{when using \code{solve()}, this is equivalent to the
\code{object} argument.  If you specify \code{object} later in
the argument list it overwrites this parameter.}

\item{b}{when using \code{solve()}, this is equivalent to the
\code{params} argument.  If you specify \code{params} as a
named argument, this overwrites the output}
}
\value{
An \dQuote{rxSolve} solve object that stores the solved
value in a special data.frame or other type as determined by
\code{returnType}. By default this has as many rows as there are
sampled time points and as many columns as system variables (as
defined by the ODEs and additional assignments in the rxode2 model
code).  It also stores information about the call to allow
dynamic updating of the solved object.

The operations for the object are similar to a data-frame, but
expand the \code{$} and \verb{[[""]]} access operators and assignment
operators to resolve based on different parameter values, initial
conditions, solver parameters, or events (by updating the \code{time}
variable).

You can call the \code{\link[=eventTable]{eventTable()}} methods on the solved object to
update the event table and resolve the system of equations.
}
\description{
This uses rxode2 family of objects, file, or model specification to
solve a ODE system.  There are many options for a solved rxode2
model, the first are the required \code{object}, and \code{events} with the
some-times optional \code{params} and \code{inits}.
}
\details{
The rest of the document focus on the different ODE solving
methods, followed by the core solving method's options, rxode2 event
handling options, rxode2's numerical stability options, rxode2's
output options, and finally internal rxode2 options or compatibility
options.
}
\references{
"New Scaling and Squaring Algorithm for the Matrix Exponential", by
Awad H. Al-Mohy and Nicholas J. Higham, August 2009

Roger B. Sidje (1998).  EXPOKIT: Software package for computing
matrix exponentials.  ACM - Transactions on Mathematical Software
\emph{24}(1), 130-156.

Hindmarsh, A. C.
\emph{ODEPACK, A Systematized Collection of ODE Solvers}.
Scientific Computing, R. S. Stepleman et al. (Eds.),
North-Holland, Amsterdam, 1983, pp. 55-64.

Petzold, L. R.
\emph{Automatic Selection of Methods for Solving Stiff and Nonstiff
Systems of Ordinary Differential Equations}.
Siam J. Sci. Stat. Comput. 4 (1983), pp. 136-148.

Hairer, E., Norsett, S. P., and Wanner, G.
\emph{Solving ordinary differential equations I, nonstiff problems}.
2nd edition, Springer Series in Computational Mathematics,
Springer-Verlag (1993).
}
\seealso{
\code{\link[=rxode2]{rxode2()}}
}
\author{
Matthew Fidler, Melissa Hallow and  Wenping Wang
}
