#' Bind the study parameters and individual parameters
#'
#' @param studyParameters These are the study parameters, often can
#'   be generated by sampling from a population.  This can be either
#'   a matrix or a data frame
#' @param individualParameters A data frame of individual parameters
#' @return Data frame that can be used in rxode2 simulations
#' @author Matthew Fidler
#' @examples
#'
#' # Function for coverting coefficient of covariance into a variance
#' lognCv <- function(x){log((x/100)^2+1)}
#'
#' set.seed(32)
#'
#' nSub  <-  100
#' nStud  <-  10
#'
#' #define theta
#' theta <- c(lka=log(0.5), # log ka
#'           lCl=log(5), # log Cl
#'           lV=log(300) # log V
#'           )
#'
#' #define theta Matrix
#' thetaMat <- lotri(lCl ~ lognCv(5),
#'                  lV  ~ lognCv(5),
#'                  lka ~ lognCv(5))
#'
#'
#' nev <- nSub*nStud
#'
#' ev1 <- data.frame(COV1=rnorm(nev,50,30),COV2=rnorm(nev,75,10),
#'                   COV3=sample(c(1.0,2.0),nev,replace=TRUE))
#'
#'
#' tmat <-rxRmvn(nStud, theta[dimnames(thetaMat)[[1]]], thetaMat)
#'
#' rxCbindStudyIndividual(tmat, ev1)
#'
#' @export
rxCbindStudyIndividual <- function(studyParameters, individualParameters) {
  if (!inherits(individualParameters, "data.frame")) {
    stop("'individualParameters' must  be a data frame", call. = FALSE)
  }
  if (inherits(studyParameters, "matrix")) {
    .dimnames <- dimnames(studyParameters)
    if (is.null(.dimnames)) {
      stop("'studyParameters' must be matrix with named columns", call. = FALSE)
    }
    .dimnames <- .dimnames[[2]]
    if (is.null(.dimnames)) {
      stop("'studyParameters' must be matrix with named columns", call. = FALSE)
    }
  } else if (!inherits(studyParameters, "data.frame")) {
    stop("'studyParameters' needs to be either a data frame or a matrix", call. = FALSE)
  }
  .Call(`_rxCbindStudyIndividual`, studyParameters, individualParameters)
}
