#define R_STRICT_HEADERS
#include <RcppArmadillo.h>
// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#ifndef RCPP_rxode2_RCPPEXPORTS_H_GEN_
#define RCPP_rxode2_RCPPEXPORTS_H_GEN_

#include <RcppEigen.h>
#include <Rcpp.h>

namespace rxode2 {

    using namespace Rcpp;

    namespace {
        void validateSignature(const char* sig) {
            Rcpp::Function require = Rcpp::Environment::base_env()["require"];
            require("rxode2", Rcpp::Named("quietly") = true);
            typedef int(*Ptr_validate)(const char*);
            static Ptr_validate p_validate = (Ptr_validate)
                R_GetCCallable("rxode2", "_rxode2_RcppExport_validate");
            if (!p_validate(sig)) {
                throw Rcpp::function_not_exported(
                    "C++ function with signature '" + std::string(sig) + "' not found in rxode2");
            }
        }
    }

    inline List rxExpandGrid_(RObject& c1, RObject& c2, RObject& type) {
        typedef SEXP(*Ptr_rxExpandGrid_)(SEXP,SEXP,SEXP);
        static Ptr_rxExpandGrid_ p_rxExpandGrid_ = NULL;
        if (p_rxExpandGrid_ == NULL) {
            validateSignature("List(*rxExpandGrid_)(RObject&,RObject&,RObject&)");
            p_rxExpandGrid_ = (Ptr_rxExpandGrid_)R_GetCCallable("rxode2", "_rxode2_rxExpandGrid_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxExpandGrid_(Shield<SEXP>(Rcpp::wrap(c1)), Shield<SEXP>(Rcpp::wrap(c2)), Shield<SEXP>(Rcpp::wrap(type)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline List rxExpandSens_(CharacterVector state, CharacterVector calcSens) {
        typedef SEXP(*Ptr_rxExpandSens_)(SEXP,SEXP);
        static Ptr_rxExpandSens_ p_rxExpandSens_ = NULL;
        if (p_rxExpandSens_ == NULL) {
            validateSignature("List(*rxExpandSens_)(CharacterVector,CharacterVector)");
            p_rxExpandSens_ = (Ptr_rxExpandSens_)R_GetCCallable("rxode2", "_rxode2_rxExpandSens_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxExpandSens_(Shield<SEXP>(Rcpp::wrap(state)), Shield<SEXP>(Rcpp::wrap(calcSens)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline List rxExpandSens2_(CharacterVector state, CharacterVector s1, CharacterVector s2) {
        typedef SEXP(*Ptr_rxExpandSens2_)(SEXP,SEXP,SEXP);
        static Ptr_rxExpandSens2_ p_rxExpandSens2_ = NULL;
        if (p_rxExpandSens2_ == NULL) {
            validateSignature("List(*rxExpandSens2_)(CharacterVector,CharacterVector,CharacterVector)");
            p_rxExpandSens2_ = (Ptr_rxExpandSens2_)R_GetCCallable("rxode2", "_rxode2_rxExpandSens2_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxExpandSens2_(Shield<SEXP>(Rcpp::wrap(state)), Shield<SEXP>(Rcpp::wrap(s1)), Shield<SEXP>(Rcpp::wrap(s2)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline List rxExpandFEta_(CharacterVector state, int neta, int pred) {
        typedef SEXP(*Ptr_rxExpandFEta_)(SEXP,SEXP,SEXP);
        static Ptr_rxExpandFEta_ p_rxExpandFEta_ = NULL;
        if (p_rxExpandFEta_ == NULL) {
            validateSignature("List(*rxExpandFEta_)(CharacterVector,int,int)");
            p_rxExpandFEta_ = (Ptr_rxExpandFEta_)R_GetCCallable("rxode2", "_rxode2_rxExpandFEta_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxExpandFEta_(Shield<SEXP>(Rcpp::wrap(state)), Shield<SEXP>(Rcpp::wrap(neta)), Shield<SEXP>(Rcpp::wrap(pred)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline std::string rxRepR0_(int neta) {
        typedef SEXP(*Ptr_rxRepR0_)(SEXP);
        static Ptr_rxRepR0_ p_rxRepR0_ = NULL;
        if (p_rxRepR0_ == NULL) {
            validateSignature("std::string(*rxRepR0_)(int)");
            p_rxRepR0_ = (Ptr_rxRepR0_)R_GetCCallable("rxode2", "_rxode2_rxRepR0_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxRepR0_(Shield<SEXP>(Rcpp::wrap(neta)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<std::string >(rcpp_result_gen);
    }

    inline List rxExpandNesting(const RObject& obj, List& nestingInfo, bool compile = false) {
        typedef SEXP(*Ptr_rxExpandNesting)(SEXP,SEXP,SEXP);
        static Ptr_rxExpandNesting p_rxExpandNesting = NULL;
        if (p_rxExpandNesting == NULL) {
            validateSignature("List(*rxExpandNesting)(const RObject&,List&,bool)");
            p_rxExpandNesting = (Ptr_rxExpandNesting)R_GetCCallable("rxode2", "_rxode2_rxExpandNesting");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxExpandNesting(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(nestingInfo)), Shield<SEXP>(Rcpp::wrap(compile)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline bool rxIs(const RObject& obj, std::string cls) {
        typedef SEXP(*Ptr_rxIs)(SEXP,SEXP);
        static Ptr_rxIs p_rxIs = NULL;
        if (p_rxIs == NULL) {
            validateSignature("bool(*rxIs)(const RObject&,std::string)");
            p_rxIs = (Ptr_rxIs)R_GetCCallable("rxode2", "_rxode2_rxIs");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxIs(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(cls)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<bool >(rcpp_result_gen);
    }

    inline Function getRxFn(std::string name) {
        typedef SEXP(*Ptr_getRxFn)(SEXP);
        static Ptr_getRxFn p_getRxFn = NULL;
        if (p_getRxFn == NULL) {
            validateSignature("Function(*getRxFn)(std::string)");
            p_getRxFn = (Ptr_getRxFn)R_GetCCallable("rxode2", "_rxode2_getRxFn");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_getRxFn(Shield<SEXP>(Rcpp::wrap(name)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<Function >(rcpp_result_gen);
    }

    inline SEXP dynLoad(std::string dll) {
        typedef SEXP(*Ptr_dynLoad)(SEXP);
        static Ptr_dynLoad p_dynLoad = NULL;
        if (p_dynLoad == NULL) {
            validateSignature("SEXP(*dynLoad)(std::string)");
            p_dynLoad = (Ptr_dynLoad)R_GetCCallable("rxode2", "_rxode2_dynLoad");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_dynLoad(Shield<SEXP>(Rcpp::wrap(dll)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline List rxModelVars_(const RObject& obj) {
        typedef SEXP(*Ptr_rxModelVars_)(SEXP);
        static Ptr_rxModelVars_ p_rxModelVars_ = NULL;
        if (p_rxModelVars_ == NULL) {
            validateSignature("List(*rxModelVars_)(const RObject&)");
            p_rxModelVars_ = (Ptr_rxModelVars_)R_GetCCallable("rxode2", "_rxode2_rxModelVars_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxModelVars_(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline RObject rxState(const RObject& obj = R_NilValue, RObject state = R_NilValue) {
        typedef SEXP(*Ptr_rxState)(SEXP,SEXP);
        static Ptr_rxState p_rxState = NULL;
        if (p_rxState == NULL) {
            validateSignature("RObject(*rxState)(const RObject&,RObject)");
            p_rxState = (Ptr_rxState)R_GetCCallable("rxode2", "_rxode2_rxState");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxState(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(state)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline CharacterVector rxParams_(const RObject& obj) {
        typedef SEXP(*Ptr_rxParams_)(SEXP);
        static Ptr_rxParams_ p_rxParams_ = NULL;
        if (p_rxParams_ == NULL) {
            validateSignature("CharacterVector(*rxParams_)(const RObject&)");
            p_rxParams_ = (Ptr_rxParams_)R_GetCCallable("rxode2", "_rxode2_rxParams_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxParams_(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<CharacterVector >(rcpp_result_gen);
    }

    inline CharacterVector rxDfdy(const RObject& obj) {
        typedef SEXP(*Ptr_rxDfdy)(SEXP);
        static Ptr_rxDfdy p_rxDfdy = NULL;
        if (p_rxDfdy == NULL) {
            validateSignature("CharacterVector(*rxDfdy)(const RObject&)");
            p_rxDfdy = (Ptr_rxDfdy)R_GetCCallable("rxode2", "_rxode2_rxDfdy");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxDfdy(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<CharacterVector >(rcpp_result_gen);
    }

    inline CharacterVector rxLhs(const RObject& obj) {
        typedef SEXP(*Ptr_rxLhs)(SEXP);
        static Ptr_rxLhs p_rxLhs = NULL;
        if (p_rxLhs == NULL) {
            validateSignature("CharacterVector(*rxLhs)(const RObject&)");
            p_rxLhs = (Ptr_rxLhs)R_GetCCallable("rxode2", "_rxode2_rxLhs");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxLhs(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<CharacterVector >(rcpp_result_gen);
    }

    inline SEXP rxInits(const RObject& obj, RObject vec = R_NilValue, Nullable<CharacterVector> req = R_NilValue, double defaultValue = 0, bool noerror = false, bool noini = false, bool rxLines = false) {
        typedef SEXP(*Ptr_rxInits)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxInits p_rxInits = NULL;
        if (p_rxInits == NULL) {
            validateSignature("SEXP(*rxInits)(const RObject&,RObject,Nullable<CharacterVector>,double,bool,bool,bool)");
            p_rxInits = (Ptr_rxInits)R_GetCCallable("rxode2", "_rxode2_rxInits");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxInits(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(vec)), Shield<SEXP>(Rcpp::wrap(req)), Shield<SEXP>(Rcpp::wrap(defaultValue)), Shield<SEXP>(Rcpp::wrap(noerror)), Shield<SEXP>(Rcpp::wrap(noini)), Shield<SEXP>(Rcpp::wrap(rxLines)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline NumericVector rxSetupIni(const RObject& obj, RObject inits = R_NilValue) {
        typedef SEXP(*Ptr_rxSetupIni)(SEXP,SEXP);
        static Ptr_rxSetupIni p_rxSetupIni = NULL;
        if (p_rxSetupIni == NULL) {
            validateSignature("NumericVector(*rxSetupIni)(const RObject&,RObject)");
            p_rxSetupIni = (Ptr_rxSetupIni)R_GetCCallable("rxode2", "_rxode2_rxSetupIni");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSetupIni(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(inits)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector rxSetupScale(const RObject& obj, RObject scale = R_NilValue, Nullable<List> extraArgs = R_NilValue) {
        typedef SEXP(*Ptr_rxSetupScale)(SEXP,SEXP,SEXP);
        static Ptr_rxSetupScale p_rxSetupScale = NULL;
        if (p_rxSetupScale == NULL) {
            validateSignature("NumericVector(*rxSetupScale)(const RObject&,RObject,Nullable<List>)");
            p_rxSetupScale = (Ptr_rxSetupScale)R_GetCCallable("rxode2", "_rxode2_rxSetupScale");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSetupScale(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(scale)), Shield<SEXP>(Rcpp::wrap(extraArgs)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline void atolRtolFactor_(double factor) {
        typedef SEXP(*Ptr_atolRtolFactor_)(SEXP);
        static Ptr_atolRtolFactor_ p_atolRtolFactor_ = NULL;
        if (p_atolRtolFactor_ == NULL) {
            validateSignature("void(*atolRtolFactor_)(double)");
            p_atolRtolFactor_ = (Ptr_atolRtolFactor_)R_GetCCallable("rxode2", "_rxode2_atolRtolFactor_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_atolRtolFactor_(Shield<SEXP>(Rcpp::wrap(factor)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
    }

    inline List rxSimThetaOmega(const Nullable<NumericVector>& params = R_NilValue, const RObject& omega = R_NilValue, const Nullable<NumericVector>& omegaDf = R_NilValue, const NumericVector& omegaLower = NumericVector::create(R_NegInf), const NumericVector& omegaUpper = NumericVector::create(R_PosInf), const bool& omegaIsChol = false, std::string omegaSeparation = "auto", const int omegaXform = 1, int nSub = 1, const Nullable<NumericMatrix>& thetaMat = R_NilValue, const NumericVector& thetaLower = NumericVector::create(R_NegInf), const NumericVector& thetaUpper = NumericVector::create(R_PosInf), const Nullable<NumericVector>& thetaDf = R_NilValue, const bool& thetaIsChol = false, int nStud = 1, const RObject sigma = R_NilValue, const NumericVector& sigmaLower = NumericVector::create(R_NegInf), const NumericVector& sigmaUpper = NumericVector::create(R_PosInf), const Nullable<NumericVector>& sigmaDf = R_NilValue, const bool& sigmaIsChol = false, std::string sigmaSeparation = "auto", const int sigmaXform = 1, int nCoresRV = 1, int nObs = 1, double dfSub = 0, double dfObs = 0, bool simSubjects = true, const LogicalVector& simVariability = LogicalVector::create(NA_LOGICAL)) {
        typedef SEXP(*Ptr_rxSimThetaOmega)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxSimThetaOmega p_rxSimThetaOmega = NULL;
        if (p_rxSimThetaOmega == NULL) {
            validateSignature("List(*rxSimThetaOmega)(const Nullable<NumericVector>&,const RObject&,const Nullable<NumericVector>&,const NumericVector&,const NumericVector&,const bool&,std::string,const int,int,const Nullable<NumericMatrix>&,const NumericVector&,const NumericVector&,const Nullable<NumericVector>&,const bool&,int,const RObject,const NumericVector&,const NumericVector&,const Nullable<NumericVector>&,const bool&,std::string,const int,int,int,double,double,bool,const LogicalVector&)");
            p_rxSimThetaOmega = (Ptr_rxSimThetaOmega)R_GetCCallable("rxode2", "_rxode2_rxSimThetaOmega");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSimThetaOmega(Shield<SEXP>(Rcpp::wrap(params)), Shield<SEXP>(Rcpp::wrap(omega)), Shield<SEXP>(Rcpp::wrap(omegaDf)), Shield<SEXP>(Rcpp::wrap(omegaLower)), Shield<SEXP>(Rcpp::wrap(omegaUpper)), Shield<SEXP>(Rcpp::wrap(omegaIsChol)), Shield<SEXP>(Rcpp::wrap(omegaSeparation)), Shield<SEXP>(Rcpp::wrap(omegaXform)), Shield<SEXP>(Rcpp::wrap(nSub)), Shield<SEXP>(Rcpp::wrap(thetaMat)), Shield<SEXP>(Rcpp::wrap(thetaLower)), Shield<SEXP>(Rcpp::wrap(thetaUpper)), Shield<SEXP>(Rcpp::wrap(thetaDf)), Shield<SEXP>(Rcpp::wrap(thetaIsChol)), Shield<SEXP>(Rcpp::wrap(nStud)), Shield<SEXP>(Rcpp::wrap(sigma)), Shield<SEXP>(Rcpp::wrap(sigmaLower)), Shield<SEXP>(Rcpp::wrap(sigmaUpper)), Shield<SEXP>(Rcpp::wrap(sigmaDf)), Shield<SEXP>(Rcpp::wrap(sigmaIsChol)), Shield<SEXP>(Rcpp::wrap(sigmaSeparation)), Shield<SEXP>(Rcpp::wrap(sigmaXform)), Shield<SEXP>(Rcpp::wrap(nCoresRV)), Shield<SEXP>(Rcpp::wrap(nObs)), Shield<SEXP>(Rcpp::wrap(dfSub)), Shield<SEXP>(Rcpp::wrap(dfObs)), Shield<SEXP>(Rcpp::wrap(simSubjects)), Shield<SEXP>(Rcpp::wrap(simVariability)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline LogicalVector rxSolveFree() {
        typedef SEXP(*Ptr_rxSolveFree)();
        static Ptr_rxSolveFree p_rxSolveFree = NULL;
        if (p_rxSolveFree == NULL) {
            validateSignature("LogicalVector(*rxSolveFree)()");
            p_rxSolveFree = (Ptr_rxSolveFree)R_GetCCallable("rxode2", "_rxode2_rxSolveFree");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSolveFree();
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<LogicalVector >(rcpp_result_gen);
    }

    inline SEXP rxSolve_(const RObject& obj, const List& rxControl, const Nullable<CharacterVector>& specParams, const Nullable<List>& extraArgs, const RObject& params, const RObject& events, const RObject& inits, const int setupOnly) {
        typedef SEXP(*Ptr_rxSolve_)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxSolve_ p_rxSolve_ = NULL;
        if (p_rxSolve_ == NULL) {
            validateSignature("SEXP(*rxSolve_)(const RObject&,const List&,const Nullable<CharacterVector>&,const Nullable<List>&,const RObject&,const RObject&,const RObject&,const int)");
            p_rxSolve_ = (Ptr_rxSolve_)R_GetCCallable("rxode2", "_rxode2_rxSolve_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSolve_(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(rxControl)), Shield<SEXP>(Rcpp::wrap(specParams)), Shield<SEXP>(Rcpp::wrap(extraArgs)), Shield<SEXP>(Rcpp::wrap(params)), Shield<SEXP>(Rcpp::wrap(events)), Shield<SEXP>(Rcpp::wrap(inits)), Shield<SEXP>(Rcpp::wrap(setupOnly)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline CharacterVector rxSolveDollarNames(RObject obj) {
        typedef SEXP(*Ptr_rxSolveDollarNames)(SEXP);
        static Ptr_rxSolveDollarNames p_rxSolveDollarNames = NULL;
        if (p_rxSolveDollarNames == NULL) {
            validateSignature("CharacterVector(*rxSolveDollarNames)(RObject)");
            p_rxSolveDollarNames = (Ptr_rxSolveDollarNames)R_GetCCallable("rxode2", "_rxode2_rxSolveDollarNames");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSolveDollarNames(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<CharacterVector >(rcpp_result_gen);
    }

    inline RObject rxSolveGet(RObject obj, RObject arg, LogicalVector exact = true) {
        typedef SEXP(*Ptr_rxSolveGet)(SEXP,SEXP,SEXP);
        static Ptr_rxSolveGet p_rxSolveGet = NULL;
        if (p_rxSolveGet == NULL) {
            validateSignature("RObject(*rxSolveGet)(RObject,RObject,LogicalVector)");
            p_rxSolveGet = (Ptr_rxSolveGet)R_GetCCallable("rxode2", "_rxode2_rxSolveGet");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSolveGet(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(arg)), Shield<SEXP>(Rcpp::wrap(exact)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline RObject rxSolveUpdate(RObject obj, RObject arg = R_NilValue, RObject value = R_NilValue) {
        typedef SEXP(*Ptr_rxSolveUpdate)(SEXP,SEXP,SEXP);
        static Ptr_rxSolveUpdate p_rxSolveUpdate = NULL;
        if (p_rxSolveUpdate == NULL) {
            validateSignature("RObject(*rxSolveUpdate)(RObject,RObject,RObject)");
            p_rxSolveUpdate = (Ptr_rxSolveUpdate)R_GetCCallable("rxode2", "_rxode2_rxSolveUpdate");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSolveUpdate(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(arg)), Shield<SEXP>(Rcpp::wrap(value)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline SEXP rxSolveSEXP(SEXP objS, SEXP rxControlS, SEXP specParamsS, SEXP extraArgsS, SEXP paramsS, SEXP eventsS, SEXP initsS, SEXP setupOnlyS) {
        typedef SEXP(*Ptr_rxSolveSEXP)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxSolveSEXP p_rxSolveSEXP = NULL;
        if (p_rxSolveSEXP == NULL) {
            validateSignature("SEXP(*rxSolveSEXP)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP)");
            p_rxSolveSEXP = (Ptr_rxSolveSEXP)R_GetCCallable("rxode2", "_rxode2_rxSolveSEXP");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSolveSEXP(Shield<SEXP>(Rcpp::wrap(objS)), Shield<SEXP>(Rcpp::wrap(rxControlS)), Shield<SEXP>(Rcpp::wrap(specParamsS)), Shield<SEXP>(Rcpp::wrap(extraArgsS)), Shield<SEXP>(Rcpp::wrap(paramsS)), Shield<SEXP>(Rcpp::wrap(eventsS)), Shield<SEXP>(Rcpp::wrap(initsS)), Shield<SEXP>(Rcpp::wrap(setupOnlyS)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline void rxRmModelLib_(std::string str) {
        typedef SEXP(*Ptr_rxRmModelLib_)(SEXP);
        static Ptr_rxRmModelLib_ p_rxRmModelLib_ = NULL;
        if (p_rxRmModelLib_ == NULL) {
            validateSignature("void(*rxRmModelLib_)(std::string)");
            p_rxRmModelLib_ = (Ptr_rxRmModelLib_)R_GetCCallable("rxode2", "_rxode2_rxRmModelLib_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxRmModelLib_(Shield<SEXP>(Rcpp::wrap(str)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
    }

    inline RObject rxGetrxode2(RObject obj) {
        typedef SEXP(*Ptr_rxGetrxode2)(SEXP);
        static Ptr_rxGetrxode2 p_rxGetrxode2 = NULL;
        if (p_rxGetrxode2 == NULL) {
            validateSignature("RObject(*rxGetrxode2)(RObject)");
            p_rxGetrxode2 = (Ptr_rxGetrxode2)R_GetCCallable("rxode2", "_rxode2_rxGetrxode2");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxGetrxode2(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline bool rxIsCurrent(RObject obj) {
        typedef SEXP(*Ptr_rxIsCurrent)(SEXP);
        static Ptr_rxIsCurrent p_rxIsCurrent = NULL;
        if (p_rxIsCurrent == NULL) {
            validateSignature("bool(*rxIsCurrent)(RObject)");
            p_rxIsCurrent = (Ptr_rxIsCurrent)R_GetCCallable("rxode2", "_rxode2_rxIsCurrent");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxIsCurrent(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<bool >(rcpp_result_gen);
    }

    inline void rxAssignPtr(SEXP object = R_NilValue) {
        typedef SEXP(*Ptr_rxAssignPtr)(SEXP);
        static Ptr_rxAssignPtr p_rxAssignPtr = NULL;
        if (p_rxAssignPtr == NULL) {
            validateSignature("void(*rxAssignPtr)(SEXP)");
            p_rxAssignPtr = (Ptr_rxAssignPtr)R_GetCCallable("rxode2", "_rxode2_rxAssignPtr");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxAssignPtr(Shield<SEXP>(Rcpp::wrap(object)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
    }

    inline std::string rxDll(RObject obj) {
        typedef SEXP(*Ptr_rxDll)(SEXP);
        static Ptr_rxDll p_rxDll = NULL;
        if (p_rxDll == NULL) {
            validateSignature("std::string(*rxDll)(RObject)");
            p_rxDll = (Ptr_rxDll)R_GetCCallable("rxode2", "_rxode2_rxDll");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxDll(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<std::string >(rcpp_result_gen);
    }

    inline CharacterVector rxC(RObject obj) {
        typedef SEXP(*Ptr_rxC)(SEXP);
        static Ptr_rxC p_rxC = NULL;
        if (p_rxC == NULL) {
            validateSignature("CharacterVector(*rxC)(RObject)");
            p_rxC = (Ptr_rxC)R_GetCCallable("rxode2", "_rxode2_rxC");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxC(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<CharacterVector >(rcpp_result_gen);
    }

    inline bool rxIsLoaded(RObject obj) {
        typedef SEXP(*Ptr_rxIsLoaded)(SEXP);
        static Ptr_rxIsLoaded p_rxIsLoaded = NULL;
        if (p_rxIsLoaded == NULL) {
            validateSignature("bool(*rxIsLoaded)(RObject)");
            p_rxIsLoaded = (Ptr_rxIsLoaded)R_GetCCallable("rxode2", "_rxode2_rxIsLoaded");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxIsLoaded(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<bool >(rcpp_result_gen);
    }

    inline bool rxDynLoad(RObject obj) {
        typedef SEXP(*Ptr_rxDynLoad)(SEXP);
        static Ptr_rxDynLoad p_rxDynLoad = NULL;
        if (p_rxDynLoad == NULL) {
            validateSignature("bool(*rxDynLoad)(RObject)");
            p_rxDynLoad = (Ptr_rxDynLoad)R_GetCCallable("rxode2", "_rxode2_rxDynLoad");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxDynLoad(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<bool >(rcpp_result_gen);
    }

    inline RObject rxLock(RObject obj) {
        typedef SEXP(*Ptr_rxLock)(SEXP);
        static Ptr_rxLock p_rxLock = NULL;
        if (p_rxLock == NULL) {
            validateSignature("RObject(*rxLock)(RObject)");
            p_rxLock = (Ptr_rxLock)R_GetCCallable("rxode2", "_rxode2_rxLock");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxLock(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline RObject rxUnlock(RObject obj) {
        typedef SEXP(*Ptr_rxUnlock)(SEXP);
        static Ptr_rxUnlock p_rxUnlock = NULL;
        if (p_rxUnlock == NULL) {
            validateSignature("RObject(*rxUnlock)(RObject)");
            p_rxUnlock = (Ptr_rxUnlock)R_GetCCallable("rxode2", "_rxode2_rxUnlock");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxUnlock(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline bool rxAllowUnload(bool allow) {
        typedef SEXP(*Ptr_rxAllowUnload)(SEXP);
        static Ptr_rxAllowUnload p_rxAllowUnload = NULL;
        if (p_rxAllowUnload == NULL) {
            validateSignature("bool(*rxAllowUnload)(bool)");
            p_rxAllowUnload = (Ptr_rxAllowUnload)R_GetCCallable("rxode2", "_rxode2_rxAllowUnload");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxAllowUnload(Shield<SEXP>(Rcpp::wrap(allow)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<bool >(rcpp_result_gen);
    }

    inline RObject rxUnloadAll_() {
        typedef SEXP(*Ptr_rxUnloadAll_)();
        static Ptr_rxUnloadAll_ p_rxUnloadAll_ = NULL;
        if (p_rxUnloadAll_ == NULL) {
            validateSignature("RObject(*rxUnloadAll_)()");
            p_rxUnloadAll_ = (Ptr_rxUnloadAll_)R_GetCCallable("rxode2", "_rxode2_rxUnloadAll_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxUnloadAll_();
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline bool rxDynUnload(RObject obj) {
        typedef SEXP(*Ptr_rxDynUnload)(SEXP);
        static Ptr_rxDynUnload p_rxDynUnload = NULL;
        if (p_rxDynUnload == NULL) {
            validateSignature("bool(*rxDynUnload)(RObject)");
            p_rxDynUnload = (Ptr_rxDynUnload)R_GetCCallable("rxode2", "_rxode2_rxDynUnload");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxDynUnload(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<bool >(rcpp_result_gen);
    }

    inline bool rxDelete(RObject obj) {
        typedef SEXP(*Ptr_rxDelete)(SEXP);
        static Ptr_rxDelete p_rxDelete = NULL;
        if (p_rxDelete == NULL) {
            validateSignature("bool(*rxDelete)(RObject)");
            p_rxDelete = (Ptr_rxDelete)R_GetCCallable("rxode2", "_rxode2_rxDelete");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxDelete(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<bool >(rcpp_result_gen);
    }

    inline SEXP setRstudio(bool isRstudio = false) {
        typedef SEXP(*Ptr_setRstudio)(SEXP);
        static Ptr_setRstudio p_setRstudio = NULL;
        if (p_setRstudio == NULL) {
            validateSignature("SEXP(*setRstudio)(bool)");
            p_setRstudio = (Ptr_setRstudio)R_GetCCallable("rxode2", "_rxode2_setRstudio");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_setRstudio(Shield<SEXP>(Rcpp::wrap(isRstudio)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline SEXP setProgSupported(int isSupported = 1) {
        typedef SEXP(*Ptr_setProgSupported)(SEXP);
        static Ptr_setProgSupported p_setProgSupported = NULL;
        if (p_setProgSupported == NULL) {
            validateSignature("SEXP(*setProgSupported)(int)");
            p_setProgSupported = (Ptr_setProgSupported)R_GetCCallable("rxode2", "_rxode2_setProgSupported");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_setProgSupported(Shield<SEXP>(Rcpp::wrap(isSupported)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline SEXP getProgSupported() {
        typedef SEXP(*Ptr_getProgSupported)();
        static Ptr_getProgSupported p_getProgSupported = NULL;
        if (p_getProgSupported == NULL) {
            validateSignature("SEXP(*getProgSupported)()");
            p_getProgSupported = (Ptr_getProgSupported)R_GetCCallable("rxode2", "_rxode2_getProgSupported");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_getProgSupported();
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline List rxUpdateTrans_(List ret, std::string prefix, std::string libName) {
        typedef SEXP(*Ptr_rxUpdateTrans_)(SEXP,SEXP,SEXP);
        static Ptr_rxUpdateTrans_ p_rxUpdateTrans_ = NULL;
        if (p_rxUpdateTrans_ == NULL) {
            validateSignature("List(*rxUpdateTrans_)(List,std::string,std::string)");
            p_rxUpdateTrans_ = (Ptr_rxUpdateTrans_)R_GetCCallable("rxode2", "_rxode2_rxUpdateTrans_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxUpdateTrans_(Shield<SEXP>(Rcpp::wrap(ret)), Shield<SEXP>(Rcpp::wrap(prefix)), Shield<SEXP>(Rcpp::wrap(libName)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline List dropUnitsRxSolve(List x) {
        typedef SEXP(*Ptr_dropUnitsRxSolve)(SEXP);
        static Ptr_dropUnitsRxSolve p_dropUnitsRxSolve = NULL;
        if (p_dropUnitsRxSolve == NULL) {
            validateSignature("List(*dropUnitsRxSolve)(List)");
            p_dropUnitsRxSolve = (Ptr_dropUnitsRxSolve)R_GetCCallable("rxode2", "_rxode2_dropUnitsRxSolve");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_dropUnitsRxSolve(Shield<SEXP>(Rcpp::wrap(x)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline bool rxSetSilentErr(int silent) {
        typedef SEXP(*Ptr_rxSetSilentErr)(SEXP);
        static Ptr_rxSetSilentErr p_rxSetSilentErr = NULL;
        if (p_rxSetSilentErr == NULL) {
            validateSignature("bool(*rxSetSilentErr)(int)");
            p_rxSetSilentErr = (Ptr_rxSetSilentErr)R_GetCCallable("rxode2", "_rxode2_rxSetSilentErr");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSetSilentErr(Shield<SEXP>(Rcpp::wrap(silent)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<bool >(rcpp_result_gen);
    }

    inline NumericVector rxInv(SEXP matrix) {
        typedef SEXP(*Ptr_rxInv)(SEXP);
        static Ptr_rxInv p_rxInv = NULL;
        if (p_rxInv == NULL) {
            validateSignature("NumericVector(*rxInv)(SEXP)");
            p_rxInv = (Ptr_rxInv)R_GetCCallable("rxode2", "_rxode2_rxInv");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxInv(Shield<SEXP>(Rcpp::wrap(matrix)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline RObject rxSymInvChol(RObject invObjOrMatrix, Nullable<NumericVector> theta = R_NilValue, std::string type = "cholOmegaInv", int thetaNumber = 0) {
        typedef SEXP(*Ptr_rxSymInvChol)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxSymInvChol p_rxSymInvChol = NULL;
        if (p_rxSymInvChol == NULL) {
            validateSignature("RObject(*rxSymInvChol)(RObject,Nullable<NumericVector>,std::string,int)");
            p_rxSymInvChol = (Ptr_rxSymInvChol)R_GetCCallable("rxode2", "_rxode2_rxSymInvChol");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSymInvChol(Shield<SEXP>(Rcpp::wrap(invObjOrMatrix)), Shield<SEXP>(Rcpp::wrap(theta)), Shield<SEXP>(Rcpp::wrap(type)), Shield<SEXP>(Rcpp::wrap(thetaNumber)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline RObject rxSymInvCholEnvCalculate(List obj, std::string what, Nullable<NumericVector> theta = R_NilValue) {
        typedef SEXP(*Ptr_rxSymInvCholEnvCalculate)(SEXP,SEXP,SEXP);
        static Ptr_rxSymInvCholEnvCalculate p_rxSymInvCholEnvCalculate = NULL;
        if (p_rxSymInvCholEnvCalculate == NULL) {
            validateSignature("RObject(*rxSymInvCholEnvCalculate)(List,std::string,Nullable<NumericVector>)");
            p_rxSymInvCholEnvCalculate = (Ptr_rxSymInvCholEnvCalculate)R_GetCCallable("rxode2", "_rxode2_rxSymInvCholEnvCalculate");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSymInvCholEnvCalculate(Shield<SEXP>(Rcpp::wrap(obj)), Shield<SEXP>(Rcpp::wrap(what)), Shield<SEXP>(Rcpp::wrap(theta)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline SEXP rxRmvn_(NumericMatrix A_, arma::rowvec mu, arma::mat sigma, int ncores = 1, bool isChol = false) {
        typedef SEXP(*Ptr_rxRmvn_)(SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxRmvn_ p_rxRmvn_ = NULL;
        if (p_rxRmvn_ == NULL) {
            validateSignature("SEXP(*rxRmvn_)(NumericMatrix,arma::rowvec,arma::mat,int,bool)");
            p_rxRmvn_ = (Ptr_rxRmvn_)R_GetCCallable("rxode2", "_rxode2_rxRmvn_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxRmvn_(Shield<SEXP>(Rcpp::wrap(A_)), Shield<SEXP>(Rcpp::wrap(mu)), Shield<SEXP>(Rcpp::wrap(sigma)), Shield<SEXP>(Rcpp::wrap(ncores)), Shield<SEXP>(Rcpp::wrap(isChol)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline List rxMvnrnd(int n, arma::mat& L, arma::vec& l, arma::vec& u, arma::vec mu, double a = 0.4, double tol = 2.05) {
        typedef SEXP(*Ptr_rxMvnrnd)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxMvnrnd p_rxMvnrnd = NULL;
        if (p_rxMvnrnd == NULL) {
            validateSignature("List(*rxMvnrnd)(int,arma::mat&,arma::vec&,arma::vec&,arma::vec,double,double)");
            p_rxMvnrnd = (Ptr_rxMvnrnd)R_GetCCallable("rxode2", "_rxode2_rxMvnrnd");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxMvnrnd(Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(L)), Shield<SEXP>(Rcpp::wrap(l)), Shield<SEXP>(Rcpp::wrap(u)), Shield<SEXP>(Rcpp::wrap(mu)), Shield<SEXP>(Rcpp::wrap(a)), Shield<SEXP>(Rcpp::wrap(tol)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline List rxCholperm(arma::mat Sig, arma::vec l, arma::vec u, double eps = 1e-10) {
        typedef SEXP(*Ptr_rxCholperm)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxCholperm p_rxCholperm = NULL;
        if (p_rxCholperm == NULL) {
            validateSignature("List(*rxCholperm)(arma::mat,arma::vec,arma::vec,double)");
            p_rxCholperm = (Ptr_rxCholperm)R_GetCCallable("rxode2", "_rxode2_rxCholperm");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxCholperm(Shield<SEXP>(Rcpp::wrap(Sig)), Shield<SEXP>(Rcpp::wrap(l)), Shield<SEXP>(Rcpp::wrap(u)), Shield<SEXP>(Rcpp::wrap(eps)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline List rxGradpsi(arma::vec y, arma::mat L, arma::vec l, arma::vec u) {
        typedef SEXP(*Ptr_rxGradpsi)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxGradpsi p_rxGradpsi = NULL;
        if (p_rxGradpsi == NULL) {
            validateSignature("List(*rxGradpsi)(arma::vec,arma::mat,arma::vec,arma::vec)");
            p_rxGradpsi = (Ptr_rxGradpsi)R_GetCCallable("rxode2", "_rxode2_rxGradpsi");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxGradpsi(Shield<SEXP>(Rcpp::wrap(y)), Shield<SEXP>(Rcpp::wrap(L)), Shield<SEXP>(Rcpp::wrap(l)), Shield<SEXP>(Rcpp::wrap(u)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<List >(rcpp_result_gen);
    }

    inline NumericVector rxNleq(arma::vec l, arma::vec u, arma::mat L) {
        typedef SEXP(*Ptr_rxNleq)(SEXP,SEXP,SEXP);
        static Ptr_rxNleq p_rxNleq = NULL;
        if (p_rxNleq == NULL) {
            validateSignature("NumericVector(*rxNleq)(arma::vec,arma::vec,arma::mat)");
            p_rxNleq = (Ptr_rxNleq)R_GetCCallable("rxode2", "_rxode2_rxNleq");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxNleq(Shield<SEXP>(Rcpp::wrap(l)), Shield<SEXP>(Rcpp::wrap(u)), Shield<SEXP>(Rcpp::wrap(L)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline arma::mat rxMvrandn_(NumericMatrix A_, arma::rowvec mu, arma::mat sigma, arma::vec lower, arma::vec upper, int ncores = 1, double a = 0.4, double tol = 2.05, double nlTol = 1e-10, int nlMaxiter = 100) {
        typedef SEXP(*Ptr_rxMvrandn_)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxMvrandn_ p_rxMvrandn_ = NULL;
        if (p_rxMvrandn_ == NULL) {
            validateSignature("arma::mat(*rxMvrandn_)(NumericMatrix,arma::rowvec,arma::mat,arma::vec,arma::vec,int,double,double,double,int)");
            p_rxMvrandn_ = (Ptr_rxMvrandn_)R_GetCCallable("rxode2", "_rxode2_rxMvrandn_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxMvrandn_(Shield<SEXP>(Rcpp::wrap(A_)), Shield<SEXP>(Rcpp::wrap(mu)), Shield<SEXP>(Rcpp::wrap(sigma)), Shield<SEXP>(Rcpp::wrap(lower)), Shield<SEXP>(Rcpp::wrap(upper)), Shield<SEXP>(Rcpp::wrap(ncores)), Shield<SEXP>(Rcpp::wrap(a)), Shield<SEXP>(Rcpp::wrap(tol)), Shield<SEXP>(Rcpp::wrap(nlTol)), Shield<SEXP>(Rcpp::wrap(nlMaxiter)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<arma::mat >(rcpp_result_gen);
    }

    inline RObject rxSeedEng(int ncores = 1) {
        typedef SEXP(*Ptr_rxSeedEng)(SEXP);
        static Ptr_rxSeedEng p_rxSeedEng = NULL;
        if (p_rxSeedEng == NULL) {
            validateSignature("RObject(*rxSeedEng)(int)");
            p_rxSeedEng = (Ptr_rxSeedEng)R_GetCCallable("rxode2", "_rxode2_rxSeedEng");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxSeedEng(Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<RObject >(rcpp_result_gen);
    }

    inline IntegerVector rxbinom_(int n0, double prob, int n, int ncores) {
        typedef SEXP(*Ptr_rxbinom_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxbinom_ p_rxbinom_ = NULL;
        if (p_rxbinom_ == NULL) {
            validateSignature("IntegerVector(*rxbinom_)(int,double,int,int)");
            p_rxbinom_ = (Ptr_rxbinom_)R_GetCCallable("rxode2", "_rxode2_rxbinom_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxbinom_(Shield<SEXP>(Rcpp::wrap(n0)), Shield<SEXP>(Rcpp::wrap(prob)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<IntegerVector >(rcpp_result_gen);
    }

    inline NumericVector rxcauchy_(double location, double scale, int n, int ncores) {
        typedef SEXP(*Ptr_rxcauchy_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxcauchy_ p_rxcauchy_ = NULL;
        if (p_rxcauchy_ == NULL) {
            validateSignature("NumericVector(*rxcauchy_)(double,double,int,int)");
            p_rxcauchy_ = (Ptr_rxcauchy_)R_GetCCallable("rxode2", "_rxode2_rxcauchy_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxcauchy_(Shield<SEXP>(Rcpp::wrap(location)), Shield<SEXP>(Rcpp::wrap(scale)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector rxchisq_(double df, int n, int ncores) {
        typedef SEXP(*Ptr_rxchisq_)(SEXP,SEXP,SEXP);
        static Ptr_rxchisq_ p_rxchisq_ = NULL;
        if (p_rxchisq_ == NULL) {
            validateSignature("NumericVector(*rxchisq_)(double,int,int)");
            p_rxchisq_ = (Ptr_rxchisq_)R_GetCCallable("rxode2", "_rxode2_rxchisq_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxchisq_(Shield<SEXP>(Rcpp::wrap(df)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector rxexp_(double rate, int n, int ncores) {
        typedef SEXP(*Ptr_rxexp_)(SEXP,SEXP,SEXP);
        static Ptr_rxexp_ p_rxexp_ = NULL;
        if (p_rxexp_ == NULL) {
            validateSignature("NumericVector(*rxexp_)(double,int,int)");
            p_rxexp_ = (Ptr_rxexp_)R_GetCCallable("rxode2", "_rxode2_rxexp_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxexp_(Shield<SEXP>(Rcpp::wrap(rate)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector rxf_(double df1, double df2, int n, int ncores) {
        typedef SEXP(*Ptr_rxf_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxf_ p_rxf_ = NULL;
        if (p_rxf_ == NULL) {
            validateSignature("NumericVector(*rxf_)(double,double,int,int)");
            p_rxf_ = (Ptr_rxf_)R_GetCCallable("rxode2", "_rxode2_rxf_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxf_(Shield<SEXP>(Rcpp::wrap(df1)), Shield<SEXP>(Rcpp::wrap(df2)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector rxgamma_(double shape, double rate, int n, int ncores) {
        typedef SEXP(*Ptr_rxgamma_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxgamma_ p_rxgamma_ = NULL;
        if (p_rxgamma_ == NULL) {
            validateSignature("NumericVector(*rxgamma_)(double,double,int,int)");
            p_rxgamma_ = (Ptr_rxgamma_)R_GetCCallable("rxode2", "_rxode2_rxgamma_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxgamma_(Shield<SEXP>(Rcpp::wrap(shape)), Shield<SEXP>(Rcpp::wrap(rate)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector rxbeta_(double shape1, double shape2, int n, int ncores) {
        typedef SEXP(*Ptr_rxbeta_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxbeta_ p_rxbeta_ = NULL;
        if (p_rxbeta_ == NULL) {
            validateSignature("NumericVector(*rxbeta_)(double,double,int,int)");
            p_rxbeta_ = (Ptr_rxbeta_)R_GetCCallable("rxode2", "_rxode2_rxbeta_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxbeta_(Shield<SEXP>(Rcpp::wrap(shape1)), Shield<SEXP>(Rcpp::wrap(shape2)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline IntegerVector rxgeom_(double prob, int n, int ncores) {
        typedef SEXP(*Ptr_rxgeom_)(SEXP,SEXP,SEXP);
        static Ptr_rxgeom_ p_rxgeom_ = NULL;
        if (p_rxgeom_ == NULL) {
            validateSignature("IntegerVector(*rxgeom_)(double,int,int)");
            p_rxgeom_ = (Ptr_rxgeom_)R_GetCCallable("rxode2", "_rxode2_rxgeom_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxgeom_(Shield<SEXP>(Rcpp::wrap(prob)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<IntegerVector >(rcpp_result_gen);
    }

    inline NumericVector rxnorm_(double mean, double sd, int n, int ncores) {
        typedef SEXP(*Ptr_rxnorm_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxnorm_ p_rxnorm_ = NULL;
        if (p_rxnorm_ == NULL) {
            validateSignature("NumericVector(*rxnorm_)(double,double,int,int)");
            p_rxnorm_ = (Ptr_rxnorm_)R_GetCCallable("rxode2", "_rxode2_rxnorm_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxnorm_(Shield<SEXP>(Rcpp::wrap(mean)), Shield<SEXP>(Rcpp::wrap(sd)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline IntegerVector rxpois_(double lambda, int n, int ncores) {
        typedef SEXP(*Ptr_rxpois_)(SEXP,SEXP,SEXP);
        static Ptr_rxpois_ p_rxpois_ = NULL;
        if (p_rxpois_ == NULL) {
            validateSignature("IntegerVector(*rxpois_)(double,int,int)");
            p_rxpois_ = (Ptr_rxpois_)R_GetCCallable("rxode2", "_rxode2_rxpois_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxpois_(Shield<SEXP>(Rcpp::wrap(lambda)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<IntegerVector >(rcpp_result_gen);
    }

    inline NumericVector rxt__(double df, int n, int ncores) {
        typedef SEXP(*Ptr_rxt__)(SEXP,SEXP,SEXP);
        static Ptr_rxt__ p_rxt__ = NULL;
        if (p_rxt__ == NULL) {
            validateSignature("NumericVector(*rxt__)(double,int,int)");
            p_rxt__ = (Ptr_rxt__)R_GetCCallable("rxode2", "_rxode2_rxt__");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxt__(Shield<SEXP>(Rcpp::wrap(df)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector rxunif_(double low, double hi, int n, int ncores) {
        typedef SEXP(*Ptr_rxunif_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxunif_ p_rxunif_ = NULL;
        if (p_rxunif_ == NULL) {
            validateSignature("NumericVector(*rxunif_)(double,double,int,int)");
            p_rxunif_ = (Ptr_rxunif_)R_GetCCallable("rxode2", "_rxode2_rxunif_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxunif_(Shield<SEXP>(Rcpp::wrap(low)), Shield<SEXP>(Rcpp::wrap(hi)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline NumericVector rxweibull_(double shape, double scale, int n, int ncores) {
        typedef SEXP(*Ptr_rxweibull_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxweibull_ p_rxweibull_ = NULL;
        if (p_rxweibull_ == NULL) {
            validateSignature("NumericVector(*rxweibull_)(double,double,int,int)");
            p_rxweibull_ = (Ptr_rxweibull_)R_GetCCallable("rxode2", "_rxode2_rxweibull_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxweibull_(Shield<SEXP>(Rcpp::wrap(shape)), Shield<SEXP>(Rcpp::wrap(scale)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline SEXP rxRmvn0(NumericMatrix& A_, arma::rowvec mu, arma::mat sigma, arma::vec lower, arma::vec upper, int ncores = 1, bool isChol = false, double a = 0.4, double tol = 2.05, double nlTol = 1e-10, int nlMaxiter = 100) {
        typedef SEXP(*Ptr_rxRmvn0)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxRmvn0 p_rxRmvn0 = NULL;
        if (p_rxRmvn0 == NULL) {
            validateSignature("SEXP(*rxRmvn0)(NumericMatrix&,arma::rowvec,arma::mat,arma::vec,arma::vec,int,bool,double,double,double,int)");
            p_rxRmvn0 = (Ptr_rxRmvn0)R_GetCCallable("rxode2", "_rxode2_rxRmvn0");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxRmvn0(Shield<SEXP>(Rcpp::wrap(A_)), Shield<SEXP>(Rcpp::wrap(mu)), Shield<SEXP>(Rcpp::wrap(sigma)), Shield<SEXP>(Rcpp::wrap(lower)), Shield<SEXP>(Rcpp::wrap(upper)), Shield<SEXP>(Rcpp::wrap(ncores)), Shield<SEXP>(Rcpp::wrap(isChol)), Shield<SEXP>(Rcpp::wrap(a)), Shield<SEXP>(Rcpp::wrap(tol)), Shield<SEXP>(Rcpp::wrap(nlTol)), Shield<SEXP>(Rcpp::wrap(nlMaxiter)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline SEXP rxRmvnSEXP(SEXP nS, SEXP muS, SEXP sigmaS, SEXP lowerS, SEXP upperS, SEXP ncoresS, SEXP isCholS, SEXP keepNamesS, SEXP aS, SEXP tolS, SEXP nlTolS, SEXP nlMaxiterS) {
        typedef SEXP(*Ptr_rxRmvnSEXP)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxRmvnSEXP p_rxRmvnSEXP = NULL;
        if (p_rxRmvnSEXP == NULL) {
            validateSignature("SEXP(*rxRmvnSEXP)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP)");
            p_rxRmvnSEXP = (Ptr_rxRmvnSEXP)R_GetCCallable("rxode2", "_rxode2_rxRmvnSEXP");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxRmvnSEXP(Shield<SEXP>(Rcpp::wrap(nS)), Shield<SEXP>(Rcpp::wrap(muS)), Shield<SEXP>(Rcpp::wrap(sigmaS)), Shield<SEXP>(Rcpp::wrap(lowerS)), Shield<SEXP>(Rcpp::wrap(upperS)), Shield<SEXP>(Rcpp::wrap(ncoresS)), Shield<SEXP>(Rcpp::wrap(isCholS)), Shield<SEXP>(Rcpp::wrap(keepNamesS)), Shield<SEXP>(Rcpp::wrap(aS)), Shield<SEXP>(Rcpp::wrap(tolS)), Shield<SEXP>(Rcpp::wrap(nlTolS)), Shield<SEXP>(Rcpp::wrap(nlMaxiterS)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<SEXP >(rcpp_result_gen);
    }

    inline NumericVector rpp_(SEXP nS, SEXP lambdaS, SEXP gammaS, SEXP probS, SEXP t0S, SEXP tmaxS, SEXP randomOrderS) {
        typedef SEXP(*Ptr_rpp_)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP);
        static Ptr_rpp_ p_rpp_ = NULL;
        if (p_rpp_ == NULL) {
            validateSignature("NumericVector(*rpp_)(SEXP,SEXP,SEXP,SEXP,SEXP,SEXP,SEXP)");
            p_rpp_ = (Ptr_rpp_)R_GetCCallable("rxode2", "_rxode2_rpp_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rpp_(Shield<SEXP>(Rcpp::wrap(nS)), Shield<SEXP>(Rcpp::wrap(lambdaS)), Shield<SEXP>(Rcpp::wrap(gammaS)), Shield<SEXP>(Rcpp::wrap(probS)), Shield<SEXP>(Rcpp::wrap(t0S)), Shield<SEXP>(Rcpp::wrap(tmaxS)), Shield<SEXP>(Rcpp::wrap(randomOrderS)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline double rxordSelect(double u, NumericVector cs) {
        typedef SEXP(*Ptr_rxordSelect)(SEXP,SEXP);
        static Ptr_rxordSelect p_rxordSelect = NULL;
        if (p_rxordSelect == NULL) {
            validateSignature("double(*rxordSelect)(double,NumericVector)");
            p_rxordSelect = (Ptr_rxordSelect)R_GetCCallable("rxode2", "_rxode2_rxordSelect");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxordSelect(Shield<SEXP>(Rcpp::wrap(u)), Shield<SEXP>(Rcpp::wrap(cs)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<double >(rcpp_result_gen);
    }

    inline arma::mat rxrandnV(unsigned int nrow, unsigned int ncol) {
        typedef SEXP(*Ptr_rxrandnV)(SEXP,SEXP);
        static Ptr_rxrandnV p_rxrandnV = NULL;
        if (p_rxrandnV == NULL) {
            validateSignature("arma::mat(*rxrandnV)(unsigned int,unsigned int)");
            p_rxrandnV = (Ptr_rxrandnV)R_GetCCallable("rxode2", "_rxode2_rxrandnV");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxrandnV(Shield<SEXP>(Rcpp::wrap(nrow)), Shield<SEXP>(Rcpp::wrap(ncol)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<arma::mat >(rcpp_result_gen);
    }

    inline NumericVector rxnormV_(double mean, double sd, int n, int ncores) {
        typedef SEXP(*Ptr_rxnormV_)(SEXP,SEXP,SEXP,SEXP);
        static Ptr_rxnormV_ p_rxnormV_ = NULL;
        if (p_rxnormV_ == NULL) {
            validateSignature("NumericVector(*rxnormV_)(double,double,int,int)");
            p_rxnormV_ = (Ptr_rxnormV_)R_GetCCallable("rxode2", "_rxode2_rxnormV_");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxnormV_(Shield<SEXP>(Rcpp::wrap(mean)), Shield<SEXP>(Rcpp::wrap(sd)), Shield<SEXP>(Rcpp::wrap(n)), Shield<SEXP>(Rcpp::wrap(ncores)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

    inline LogicalVector isNullZero(RObject obj) {
        typedef SEXP(*Ptr_isNullZero)(SEXP);
        static Ptr_isNullZero p_isNullZero = NULL;
        if (p_isNullZero == NULL) {
            validateSignature("LogicalVector(*isNullZero)(RObject)");
            p_isNullZero = (Ptr_isNullZero)R_GetCCallable("rxode2", "_rxode2_isNullZero");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_isNullZero(Shield<SEXP>(Rcpp::wrap(obj)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<LogicalVector >(rcpp_result_gen);
    }

    inline NumericVector rxErf(NumericVector v) {
        typedef SEXP(*Ptr_rxErf)(SEXP);
        static Ptr_rxErf p_rxErf = NULL;
        if (p_rxErf == NULL) {
            validateSignature("NumericVector(*rxErf)(NumericVector)");
            p_rxErf = (Ptr_rxErf)R_GetCCallable("rxode2", "_rxode2_rxErf");
        }
        RObject rcpp_result_gen;
        {
            RNGScope RCPP_rngScope_gen;
            rcpp_result_gen = p_rxErf(Shield<SEXP>(Rcpp::wrap(v)));
        }
        if (rcpp_result_gen.inherits("interrupted-error"))
            throw Rcpp::internal::InterruptedException();
        if (Rcpp::internal::isLongjumpSentinel(rcpp_result_gen))
            throw Rcpp::LongjumpException(rcpp_result_gen);
        if (rcpp_result_gen.inherits("try-error"))
            throw Rcpp::exception(Rcpp::as<std::string>(rcpp_result_gen).c_str());
        return Rcpp::as<NumericVector >(rcpp_result_gen);
    }

}

#endif // RCPP_rxode2_RCPPEXPORTS_H_GEN_
