% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxode2.R
\name{rxModelVars}
\alias{rxModelVars}
\alias{rxModelVarsS3}
\alias{rxModelVarsS3.rxUi}
\alias{rxModelVarsS3.default}
\title{All model variables for a rxode2 object}
\usage{
rxModelVars(obj)

rxModelVarsS3(obj)

\method{rxModelVarsS3}{rxUi}(obj)

\method{rxModelVarsS3}{default}(obj)
}
\arguments{
\item{obj}{rxode2 family of objects}
}
\value{
A list of rxode2 model properties including:
\itemize{
\item \code{params}{ a character vector of names of the model parameters}
\item \code{lhs}{ a character vector of the names of the model calculated parameters}
\item \code{state}{ a character vector of the compartments in rxode2 object}
\item \code{trans}{ a named vector of translated model properties
including what type of jacobian is specified, the \code{C} function prefixes,
as well as the \code{C} functions names to be called through the compiled model.}
\item \code{md5}{a named vector that gives the digest of the model (\code{file_md5}) and the parsed model
(\code{parsed_md5})}
\item \code{model}{ a named vector giving the input model (\code{model}),
normalized model (no comments and standard syntax for parsing, \code{normModel}),
and interim code that is used to generate the final C file \code{parseModel}}
}
}
\description{
Return all the known model variables for a specified rxode2 object
}
\details{
These items are only calculated after compilation; they are
built-into the rxode2 compiled DLL.

To allow extensible a s3 hook is added in the function \code{rxModelVarsS3}
}
\seealso{
Other Query model information: 
\code{\link{rxDfdy}()},
\code{\link{rxInits}()},
\code{\link{rxLhs}()},
\code{\link{rxParams}()},
\code{\link{rxState}()}
}
\author{
Matthew L. Fidler
}
\concept{Query model information}
\keyword{internal}
