% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{rxUiDecompress}
\alias{rxUiDecompress}
\alias{rxUiCompress}
\title{Compress/Decompress \code{rxode2} ui}
\usage{
rxUiDecompress(ui)

rxUiCompress(ui)
}
\arguments{
\item{ui}{rxode2 ui object}
}
\value{
A compressed or decompressed rxui object
}
\description{
Compress/Decompress \code{rxode2} ui
}
\examples{
one.cmt <- function() {
  ini({
    ## You may label each parameter with a comment
    tka <- 0.45 # Log Ka
    tcl <- log(c(0, 2.7, 100)) # Log Cl
    ## This works with interactive models
    ## You may also label the preceding line with label("label text")
    tv <- 3.45; label("log V")
    ## the label("Label name") works with all models
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd) | tmp
  })
}

f <- rxode2(one.cmt)
print(class(f))
print(is.environment(f))

f  <- rxUiDecompress(f)
print(class(f))
print(is.environment(f))

f  <- rxUiCompress(f)
print(class(f))
print(is.environment(f))

}
\author{
Matthew L. Fidler
}
