% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wk-utils.R
\name{s2_unprojection_filter}
\alias{s2_unprojection_filter}
\alias{s2_projection_filter}
\alias{s2_projection_plate_carree}
\alias{s2_projection_mercator}
\title{Low-level wk filters and handlers}
\usage{
s2_unprojection_filter(
  handler,
  projection = s2_projection_plate_carree(),
  tessellate_tol = Inf
)

s2_projection_filter(
  handler,
  projection = s2_projection_plate_carree(),
  tessellate_tol = Inf
)

s2_projection_plate_carree()

s2_projection_mercator()
}
\arguments{
\item{handler}{A \link[wk:wk_handle]{wk_handler} object.}

\item{projection}{One of \code{\link[=s2_projection_plate_carree]{s2_projection_plate_carree()}} or
\code{\link[=s2_projection_mercator]{s2_projection_mercator()}}}

\item{tessellate_tol}{An angle in radians. Points will not be added
if a line segment is within this distance of a point.}
}
\value{
\itemize{
\item \code{s2_unprojection_filter()}, \code{s2_projection_filter()}: A \code{new_wk_handler()}
\item \code{s2_projection_plate_carree()}, \code{s2_projection_mercator()}: An external pointer
to an S2 projection.
}
}
\description{
Low-level wk filters and handlers
}
\examples{
library(wk)

# simple conversion of individual coordinates *to* unit sphere
# space
wk_handle(
  wkt("LINESTRING (0 0, 0 45, -60 45)"),
  s2_unprojection_filter(wkt_format_handler(5))
)

# simple conversion of individual coordinates *from* unit sphere
# space
wk_handle(
  wkt("LINESTRING Z (1 0 0, 0.7071 0 0.7071, 0.3536 -0.6124 0.7071)"),
  s2_projection_filter(wkt_format_handler(5))
)

# use tessellate_tol to force points to be added to an edge
# unprojection will ensure an edge maintains its cartesian
# assumption when transformed to the unit sphere
# (i.e., what you probably want when importing a geography)
wk_handle(
  wkt("LINESTRING (0 0, 0 45, -60 45)"),
  s2_unprojection_filter(wkt_format_handler(5), tessellate_tol = 0.001)
)

# projection will ensure an edge maintains its geodesic
# assumption when transformed to projected space
# (i.e., what you probably want when exporting a geography)
wk_handle(
  wkt("LINESTRING Z (1 0 0, 0.7071 0 0.7071, 0.3536 -0.6124 0.7071)"),
  s2_projection_filter(wkt_format_handler(5), tessellate_tol = 0.001)
)

}
