% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMS.R
\name{RMS}
\alias{RMS}
\title{Compute root mean square error}
\usage{
RMS(exp, obs, time_dim = "sdate", dat_dim = "dataset", comp_dim = NULL,
  limits = NULL, conf = TRUE, conf.lev = 0.95, ncores = NULL)
}
\arguments{
\item{exp}{A named numeric array of experimental data, with at least two 
dimensions 'time_dim' and 'dat_dim'. It can also be a vector with the 
same length as 'obs', then the vector will automatically be 'time_dim' and 
'dat_dim' will be 1.}

\item{obs}{A named numeric array of observational data, same dimensions as
parameter 'exp' except along dat_dim. It can also be a vector with the same
length as 'exp', then the vector will automatically be 'time_dim' and 
'dat_dim' will be 1.}

\item{time_dim}{A character string indicating the name of dimension along
which the correlations are computed. The default value is 'sdate'.}

\item{dat_dim}{A character string indicating the name of member (nobs/nexp) 
dimension. The default value is 'dataset'.}

\item{comp_dim}{A character string indicating the name of dimension along which
obs is taken into account only if it is complete. The default value
is NULL.}

\item{limits}{A vector of two integers indicating the range along comp_dim to 
be completed. The default value is c(1, length(comp_dim dimension)).}

\item{conf}{A logical value indicating whether to retrieve the confidence 
intervals or not. The default value is TRUE.}

\item{conf.lev}{A numeric indicating the confidence level for the 
regression computation. The default value is 0.95.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A list containing the numeric arrays with dimension:\cr 
 c(nexp, nobs, all other dimensions of exp except time_dim).\cr
nexp is the number of experiment (i.e., dat_dim in exp), and nobs is the 
number of observation (i.e., dat_dim in obs).\cr
\item{$rms}{
 The root mean square error. 
}
\item{$conf.lower}{
 The lower confidence interval. Only present if \code{conf = TRUE}.
}
\item{$conf.upper}{
 The upper confidence interval. Only present if \code{conf = TRUE}.
}
}
\description{
Compute the root mean square error for an array of forecasts and an array of
observations. The RMSEs are computed along time_dim, the dimension which 
corresponds to the startdate dimension. If comp_dim is given, the RMSEs are 
computed only if obs along the comp_dim dimension are complete between 
limits[1] and limits[2], i.e. there are no NAs between limits[1] and 
limits[2]. This option can be activated if the user wishes to account only 
for the forecasts for which the corresponding observations are available at 
all leadtimes.\cr
The confidence interval is computed by the chi2 distribution.\cr
}
\examples{
# Load sample data as in Load() example:
 set.seed(1)
 exp1 <- array(rnorm(120), dim = c(dataset = 3, sdate = 5, ftime = 2, lon = 1, lat = 4))
 set.seed(2)
 obs1 <- array(rnorm(80),  dim = c(dataset = 2, sdate = 5, ftime = 2, lon = 1, lat = 4))
 set.seed(2)
 na <- floor(runif(10, min = 1, max = 80))
 obs1[na] <- NA
 res <- RMS(exp1, obs1, comp_dim = 'ftime')
 # Renew example when Ano and Smoothing are ready

}

