% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sGMRFmix.R
\name{sGMRFmix}
\alias{sGMRFmix}
\title{Sparse Gaussian Markov Random Field Mixtures}
\usage{
sGMRFmix(x, K, rho, kmeans = FALSE, m0 = rep(0, M), lambda0 = 1,
  alpha = NULL, pi_threshold = 1/K/100, max_iter = 500, tol = 0.1,
  verbose = TRUE)
}
\arguments{
\item{x}{data.frame. A training data.}

\item{K}{integer. Number of mixture components. Set a large enough number
because the algorithm identifies major dependency patterns from
the data via the sparse mixture model.}

\item{rho}{double. Constant that multiplies the penalty term. An optimal
value should be determined together with the threshold on the
anomaly score, so the performance of anomaly detection is maximized.}

\item{kmeans}{logical. If TRUE, initialize parameters with k-means method.
You should set TRUE for non-time series data. Default FALSE.}

\item{m0}{a numeric vector. Location parameter of Gauss-Laplace prior.
Keep default if no prior information is available. Default 0.}

\item{lambda0}{double. Coefficient for scale parameter of Gauss-Laplace
prior. Keep default if no prior information is available. Default 1.}

\item{alpha}{double. Concentration parameter of Dirichlet prior.
Keep default if no prior information is available. Default 1.}

\item{pi_threshold}{double. Threshold to decide a number of states.
If pi < pi_threshold, the states are rejected in the sense of
sparse estimation.}

\item{max_iter}{integer. Maximum number of iterations.}

\item{tol}{double. The tolerance to declare convergence.}

\item{verbose}{logical.}
}
\value{
sGMRFmix object
}
\description{
Sparse Gaussian Markov Random Field Mixtures
}
\examples{
library(sGMRFmix)

set.seed(314)
train_data <- generate_train_data()
fit <- sGMRFmix(train_data, K = 7, rho = 10)
fit

}
