#' Ecoregions of the United States
#'
#' Bailey's Ecoregions of the Conterminous United States
#'
#' @source https://www.sciencebase.gov/catalog/item/54244abde4b037b608f9e23d
"eco_us"

#' Red regionalization
#'
#' Data of the red regionalization used in Figure 1 of Stepinski and Nowosad (2018)
#'
#' @references Nowosad, Jakub, and Tomasz F. Stepinski.
#' "Spatial association between regionalizations using the information-theoretical V-measure."
#' International Journal of Geographical Information Science (2018).
#' https://doi.org/10.1080/13658816.2018.1511794
"regions1"

#' Blue regionalization
#'
#' Data of the blue regionalization used in Figure 1 of Stepinski and Nowosad (2018)
#'
#' @references Nowosad, Jakub, and Tomasz F. Stepinski.
#' "Spatial association between regionalizations using the information-theoretical V-measure."
#' International Journal of Geographical Information Science (2018).
#' https://doi.org/10.1080/13658816.2018.1511794
"regions2"

#' Red regionalization (raster version)
#'
#' Raster data of the red regionalization used in Figure 1 of Stepinski and Nowosad (2018)
#'
#' @references Nowosad, Jakub, and Tomasz F. Stepinski.
#' "Spatial association between regionalizations using the information-theoretical V-measure."
#' International Journal of Geographical Information Science (2018).
#' https://doi.org/10.1080/13658816.2018.1511794
"partitions1"

#' Blue regionalization (raster version)
#'
#' Raster data of the blue regionalization used in Figure 1 of Stepinski and Nowosad (2018)
#'
#' @references Nowosad, Jakub, and Tomasz F. Stepinski.
#' "Spatial association between regionalizations using the information-theoretical V-measure."
#' International Journal of Geographical Information Science (2018).
#' https://doi.org/10.1080/13658816.2018.1511794
"partitions2"
