% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lambdap.r
\name{lambdap}
\alias{dlambdap}
\alias{lambdap}
\alias{plambdap}
\alias{qlambdap}
\alias{rlambdap}
\title{The lambda prime distribution.}
\usage{
dlambdap(x, df, t, log = FALSE, order.max=6)

plambdap(q, df, t, lower.tail = TRUE, log.p = FALSE, order.max=6)

qlambdap(p, df, t, lower.tail = TRUE, log.p = FALSE, order.max=6)

rlambdap(n, df, t)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{df}{the degrees of freedom in the chi square.
This is not recycled against the \code{x,q,p,n}.}

\item{t}{the scaling parameter on the chi.
This is not recycled against the \code{x,q,p,n}.}

\item{log}{logical; if TRUE, densities \eqn{f} are given
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{order.max}{the order to use in the approximate density,
distribution, and quantile computations, via the Gram-Charlier,
Edeworth, or Cornish-Fisher expansion.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{log.p}{logical; if TRUE, probabilities p are given
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
 \eqn{P[X \le x]}{P[X <= x]}, otherwise, \eqn{P[X > x]}{P[X > x]}.}
}
\value{
\code{dlambdap} gives the density, \code{plambdap} gives the
distribution function, \code{qlambdap} gives the quantile function,
and \code{rlambdap} generates random deviates.

Invalid arguments will result in return value \code{NaN} with a warning.
}
\description{
Density, distribution function, quantile function and random
generation for the lambda prime distribution.
}
\details{
Suppose \eqn{y \sim \chi^2\left(\nu\right)}{y ~ x^2(v)}, and
\eqn{Z}{Z} is a standard normal.
\deqn{T = Z + t \sqrt{y/\nu}}{T = Z + t sqrt(y/v)}
takes a lambda prime distribution with parameters
\eqn{\nu, t}{v, t}.
A lambda prime random variable can be viewed as a confidence
level on a non-central t because
\deqn{t = \frac{Z' + T}{\sqrt{y/\nu}}}{t = (Z' + T)/sqrt(y/v)}
}
\note{
The PDF, CDF, and quantile function are approximated, via
the Edgeworth or Cornish Fisher approximations, which may
not be terribly accurate in the tails of the distribution.
You are warned.

The distribution parameters are \emph{not} recycled
with respect to the \code{x, p, q} or \code{n} parameters,
for, respectively, the density, distribution, quantile
and generation functions. This is for simplicity of
implementation and performance. It is, however, in contrast
to the usual R idiom for dpqr functions.
}
\examples{
rv <- rlambdap(100, 50, t=0.01)
d1 <- dlambdap(1, 50, t=0.01)
pv <- plambdap(rv, 50, t=0.01)
qv <- qlambdap(ppoints(length(rv)), 50, t=1)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Lecoutre, Bruno. "Another look at confidence intervals for the noncentral t distribution."
Journal of Modern Applied Statistical Methods 6, no. 1 (2007): 107--116.
\url{http://www.univ-rouen.fr/LMRS/Persopage/Lecoutre/telechargements/Lecoutre_Another_look-JMSAM2007_6(1).pdf}

Lecoutre, Bruno. "Two useful distributions for Bayesian predictive procedures under normal models."
Journal of Statistical Planning and Inference 79  (1999): 93--105.
}
\seealso{
t distribution functions, \code{\link{dt}, \link{pt}, \link{qt}, \link{rt}},
K prime distribution functions, \code{\link{dkprime}, \link{pkprime}, \link{qkprime}, \link{rkprime}},
upsilon distribution functions, \code{\link{dupsilon}, \link{pupsilon}, \link{qupsilon}, \link{rupsilon}},
}
\keyword{distribution}

