% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Student_t.R
\name{Student_t}
\alias{Student_t}
\title{Small Area Estimation using Hierarchical Bayesian under Student-t Distribution}
\usage{
Student_t(
  formula,
  iter.update = 3,
  iter.mcmc = 10000,
  coef,
  var.coef,
  thin = 2,
  burn.in = 2000,
  tau.u = 1,
  data
)
}
\arguments{
\item{formula}{Formula that describe the fitted model}

\item{iter.update}{Number of updates with default \code{3}}

\item{iter.mcmc}{Number of total iterations per chain with default \code{10000}}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of \code{0} with the length of the number of regression coefficients}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of \code{1} with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer with default \code{2}}

\item{burn.in}{Number of iterations to discard at the beginning with default \code{2000}}

\item{tau.u}{Prior initial value of inverse of Variance of area random effect with default \code{1}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{Est}{A vector with the values of Small Area mean Estimates using Hierarchical bayesian method }
   \item{refVar}{Estimated random effect variances}
   \item{coefficient}{A dataframe with the estimated model coefficient}
   \item{plot}{Trace, Dencity, Autocorrelation Function Plot of MCMC samples}
}
\description{
This function is implemented to variable of interest \eqn{(y)} that assumed to be a Student-t Distribution. The range of data is \eqn{(-\infty < y < \infty)}
}
\examples{
\donttest{
##Data Generation
set.seed(123)
m=30
x1=runif(m,10,20)
x2=runif(m,30,50)
b0=b1=b2=0.5
u=rnorm(m,0,1)
MU=b0+b1*x1+b2*x2+u
k=rgamma(1,10,1)
y=rt(m,k,MU)
vardir=k/(k-1)
vardir=sd(y)^2
datat=as.data.frame(cbind(y,x1,x2,vardir))
datatNs=datat
datatNs$y[c(3,14,22,29,30)] <- NA
datatNs$vardir[c(3,14,22,29,30)] <- NA


##Compute Fitted Model
##y ~ x1 +x2


## For data without any nonsampled area

formula =  y ~ x1+x2
var.coef = c(1,1,1)
coef = c(0,0,0)


## Using parameter coef and var.coef
saeHBt <- Student_t(formula,coef=coef,var.coef=var.coef,iter.update=10,data = datat)

saeHBt$Est                                 #Small Area mean Estimates
saeHBt$refVar                              #Random effect variance
saeHBt$coefficient                         #coefficient
#Load Library 'coda' to execute the plot
#autocorr.plot(saeHBt$plot[[3]]) is used to generate ACF Plot
#plot(saeHBt$plot[[3]]) is used to generate Density and trace plot

## Do not using parameter coef and var.coef
saeHBt <- Student_t(formula,data = datat)



## For data with nonsampled area use datatNs

}
}
