% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{igraph_to_phylo}
\alias{igraph_to_phylo}
\alias{get_phylogeny}
\title{Getting a phylogeny for a dataset}
\usage{
igraph_to_phylo(g)

get_phylogeny(record)
}
\arguments{
\item{g}{A taxon graph returned by \code{\link{get_taxon_graph}}}

\item{record}{A single dataset record id}
}
\value{
An \code{\link[ape:read.tree]{phylo}} object.
}
\description{
The function \code{igraph_to_phylo} takes a taxon graph (see
\code{\link{get_taxon_graph}}) and attempts to convert that to a
a \code{\link[ape:read.tree]{phylo}} object from \pkg{ape}.
This will fail if the graph is not simple (no loops or multiple edges)
or is not connected (has isolated taxa). Neither of these conditions
should happen in datasets but they do.
}
\details{
The phylogeny is assigned with equal branch lengths and so displays
showing the taxonomic hierarchy of taxa. Note that the phylogeny will
contain singleton nodes if an internal taxon has a single descendant -
see the example below showing internal node labels. The
\code{\link[ape:ape-package]{ape}} functions
\code{\link[ape:collapse.singles]{has.singles}} and
\code{\link[ape]{collapse.singles}} can be used to detect and remove
these if required.

The function \code{get_phylogeny} is simply a wrapper that calls
\code{\link{get_taxon_graph}} and then \code{igraph_to_phylo}.
}
\section{Functions}{
\itemize{
\item \code{get_phylogeny}: Get a phylogeny for a dataset
}}

\examples{
   set_example_safe_dir()
   beetle_graph <- get_taxon_graph(1400562)
   beetle_phylo <- igraph_to_phylo(beetle_graph)
   ape::plot.phylo(beetle_phylo, show.node.label = TRUE)
   # Or wrapped into a single function
   beetle_phylo <- get_phylogeny(1400562)
   ape::plot.phylo(beetle_phylo, show.node.label = TRUE)
   unset_example_safe_dir()
}
\seealso{
\code{\link{get_taxon_graph}}
}
