% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safedata_network.R
\name{safedata_network}
\alias{safedata_network}
\title{Network resources and the safedata package.}
\description{
The safedata package requires access to the internet in order to:

1. maintain an up-to-date index of datasets and the locations gazeteer,
2. download datasets and their metadata,
3. download metadata about the taxonomic coverage of datasets, and
4. search dataset metadata for relevant datasets.

These actions use two resources. The first is the safedata web server API
which provides everything except the actual datasets. The second is the
Zenodo API, which provides the datasets.

If you do not have an internet connection - or if either of the two APIs is
unavailable - the safedata package can be used as normal to load and use
datasets that have already been downloaded to the local safedata directory.
However, it will not be possible to update the dataset index, download new
datasets or search for datasets until the APIs are available. The package
should handle internet failures gracefully and provide meaningful messages.
}
\section{Note on SSL certificates}{


Downloading data uses the curl package and the underlying libcurl library.
Some older versions of Mac OS X (10.14 and earlier) provide a built-in
libcurl with an outdated set of certificates that prevents curl from
connecting to resources using LetsEncrypt for HTTPS, which includes
https://safeproject.net. To use safedata on these systems, you have to
install a newer version of curl (e.g. using brew) and then compile curl
from source, linking it to that newer libcurl. The simplest way to do this
is to use \code{export PKG_CONFIG_PATH="/usr/local/opt/curl/lib/pkgconfig"}
before installing the package: this points the installation to the package
configuration for the brew installed version of curl.
}

