% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{safe_save_file}
\alias{safe_save_file}
\alias{safe_serialize}
\title{Writes a list of tensors to the safetensors format}
\usage{
safe_save_file(tensors, path, ..., metadata = NULL)

safe_serialize(tensors, ..., metadata = NULL)
}
\arguments{
\item{tensors}{A named list of tensors. Currently only torch tensors are supported.}

\item{path}{The path to save the tensors to. It can also be a binary connection, as eg,
created with \code{file()}.}

\item{...}{Currently unused.}

\item{metadata}{An optional string that is added to the file header. Possibly
adding additional description to the weights.}
}
\value{
The path invisibly or a raw vector.
}
\description{
Writes a list of tensors to the safetensors format
}
\section{Functions}{
\itemize{
\item \code{safe_serialize()}: Serializes the tensors and returns a raw vector.

}}
\examples{
if (rlang::is_installed("torch") && torch::torch_is_installed()) {
  tensors <- list(x = torch::torch_randn(10, 10))
  temp <- tempfile()
  safe_save_file(tensors, temp)
  safe_load_file(temp)

  ser <- safe_serialize(tensors)
}

}
