% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-operation.R
\name{sf_get_job_bulk}
\alias{sf_get_job_bulk}
\title{Get Bulk API Job}
\usage{
sf_get_job_bulk(job_id, api_type = c("Bulk 1.0", "Bulk 2.0"),
  verbose = FALSE)
}
\arguments{
\item{job_id}{character; the Salesforce Id assigned to a submitted job as 
returned by \link{sf_create_job_bulk}}

\item{api_type}{character; one of "REST", "SOAP", or "Bulk" indicating 
which API to use when making the request}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{list} of parameters defining the details of the specified job id
}
\description{
This function retrieves details about a Job in the Salesforce Bulk API
}
\examples{
\dontrun{
job_info <- sf_create_job_bulk('insert', 'Account')
refreshed_job_info <- sf_get_job_bulk(job_info$id)
sf_abort_job_bulk(refreshed_job_info$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
