% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics-report.R
\name{sf_list_report_types}
\alias{sf_list_report_types}
\title{List report types}
\usage{
sf_list_report_types(as_tbl = TRUE, verbose = FALSE)
}
\arguments{
\item{as_tbl}{\code{logical}; an indicator of whether to convert the parsed
JSON into a \code{tbl_df}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} by default, or a \code{list} depending on the value of
argument \code{as_tbl}
}
\description{
\lifecycle{experimental}

Return a list of report types.
}
\examples{
\dontrun{
report_types <- sf_list_report_types()
unique_report_types <- report_types \%>\% select(reportTypes.type)

# return the results as a list
reports_as_list <- sf_list_report_types(as_tbl=FALSE)
}
}
\seealso{
\href{https://developer.salesforce.com/docs/atlas.en-us.api_analytics.meta/api_analytics/analytics_api_reporttypes_reference_list.htm}{Salesforce Documentation}
}
