% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlso.R
\name{dlso}
\alias{dlso}
\title{Latent Structure Optimization Based on Draws}
\usage{
dlso(candidates, loss = VI(), x = NULL, parallel = FALSE)
}
\arguments{
\item{candidates}{A \eqn{B}-by-\eqn{n} matrix, where each of the \eqn{B} rows
represents a clustering of \eqn{n} items using cluster labels. For the
\eqn{b}th clustering, items \eqn{i} and \eqn{j} are in the same cluster if
\code{x[b,i] == x[b,j]}. One of the rows will be used as the partition
estimate.}

\item{loss}{See the documentation for this argument in
\code{\link{partition.loss}}.}

\item{x}{See the documentation for this argument in
\code{\link{partition.loss}}.}

\item{parallel}{This argument is currently ignored and will be removed in the
future.}
}
\value{
An integer vector giving the estimated partition, encoded using
  cluster labels.
}
\description{
This function provides a partition to summarize a partition distribution
using the draws-based latent structure optimization (DLSO) method, which is
also known as the least-squares clustering method (Dahl 2006). The method
seeks to minimize an estimation criterion by picking the minimizer among the
partitions supplied by the \code{draws} argument. The implementation
currently supports the minimization of several partition estimation criteria.
For details on these criteria, see \code{\link{partition.loss}}.
}
\examples{
# For examples, use 'nCores=1' per CRAN rules, but in practice omit this.
dlso(iris.clusterings, loss=VI())
probs <- psm(iris.clusterings, nCores=1)
dlso(iris.clusterings, loss=binder(), x=probs)

# Compute loss with all draws, but pick the best among the first 10.
dlso(iris.clusterings[1:10,], loss=VI(), x=iris.clusterings)

}
\seealso{
\code{\link{partition.loss}}, \code{\link{psm}},
  \code{\link{summary.salso.estimate}}, \code{\link{salso}}
}
