% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psm.R
\name{psm}
\alias{psm}
\title{Compute an Adjacency or Pairwise Similarity Matrix}
\usage{
psm(x, nCores = 0)
}
\arguments{
\item{x}{A \eqn{B}-by-\eqn{n} matrix, where each of the \eqn{B} rows
represents a clustering of \eqn{n} items using cluster labels. For the
\eqn{b}th clustering, items \eqn{i} and \eqn{j} are in the same cluster if
\code{x[b,i] == x[b,j]}.}

\item{nCores}{The number of CPU cores to use, i.e., the number of
simultaneous runs at any given time. A value of zero indicates to use all
cores on the system.}
}
\value{
A \eqn{n}-by-\eqn{n} symmetric matrix whose \eqn{(i,j)} element gives
  the relative frequency that that items \eqn{i} and \eqn{j} are in the same
  subset (i.e., cluster).
}
\description{
If only one sample is provided, this function computes an adjacency matrix,
i.e., a binary matrix whose \eqn{(i,j)} element is one if and only if
elements \eqn{i} and \eqn{j} in the partition have the same cluster label. If
multiple samples are provided (as rows of the \code{x} matrix), this function
computes the \eqn{n}-by-\eqn{n} matrix whose \eqn{(i,j)} element gives the
relative frequency (i.e., estimated probability) that items \eqn{i} and
\eqn{j} are in the same subset (i.e., cluster).  This is the mean of the
adjacency matrices of the provided samples.
}
\examples{
# For examples, use 'nCores=1' per CRAN rules, but in practice omit this.
data(iris.clusterings)
partition <- iris.clusterings[1,]
psm(partition, nCores=1)

dim(iris.clusterings)
probs <- psm(iris.clusterings, nCores=1)
dim(probs)
probs[1:6, 1:6]

}
